% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sanity_checks.R
\name{save_edc_data_warnings}
\alias{save_edc_data_warnings}
\title{Save EDCimport warning to Excel}
\usage{
save_edc_data_warnings(
  edc_warnings = edc_data_warnings(),
  output_file = "edc_data_warnings_{project}_{date_extraction}.xlsx",
  output_dir = "output/check",
  open = FALSE,
  overwrite = TRUE,
  hide_resolved = TRUE,
  include_stops = FALSE,
  path = "deprecated"
)
}
\arguments{
\item{edc_warnings}{the result of \link{edc_data_warnings}}

\item{output_file, output_dir}{path to a \code{.xlsx} file. Use special values \code{{proj_name}} and \code{{date_extraction}}.}

\item{open}{If \code{TRUE}, overwrite any existing file.}

\item{overwrite}{If \code{TRUE}, overwrite any existing file.}

\item{hide_resolved}{If \code{TRUE}, hide sheets with no data.}

\item{include_stops}{If \code{TRUE}, also include STOP-type warnings.}

\item{path}{deprecated}
}
\value{
a logical(1), whether the file could be written, invisibly
}
\description{
Each time \link{edc_data_warn} is used, the warning is saved internally so that a summary can be retrieved using \link{edc_data_warnings}. This summary can then be saved into a \code{.xlsx} file using \code{save_edc_data_warnings()}.
}
