% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseIntersect.R
\name{summariseIndication}
\alias{summariseIndication}
\title{Summarise the indications of individuals in a drug cohort}
\usage{
summariseIndication(
  cohort,
  strata = list(),
  indicationCohortName,
  cohortId = NULL,
  indicationCohortId = NULL,
  indicationWindow = list(c(0, 0)),
  unknownIndicationTable = NULL,
  indexDate = "cohort_start_date",
  mutuallyExclusive = TRUE,
  censorDate = NULL
)
}
\arguments{
\item{cohort}{A cohort_table object.}

\item{strata}{A list of variables to stratify results. These variables
must have been added as additional columns in the cohort table.}

\item{indicationCohortName}{Name of the cohort table with potential
indications.}

\item{cohortId}{A cohort definition id to restrict by. If NULL, all cohorts
will be included.}

\item{indicationCohortId}{The target cohort ID to add indication. If NULL all
cohorts will be considered.}

\item{indicationWindow}{The time window over which to identify indications.}

\item{unknownIndicationTable}{Tables in the OMOP CDM to search for unknown
indications.}

\item{indexDate}{Name of a column that indicates the date to start the
analysis.}

\item{mutuallyExclusive}{Whether to report indications as mutually exclusive
or report them as independent results.}

\item{censorDate}{Name of a column that indicates the date to stop the
analysis, if NULL end of individuals observation is used.}
}
\value{
A summarised result
}
\description{
Summarise the observed indications of patients in a drug cohort based on
their presence in an indication cohort in a specified time window. If an
individual is not in one of the indication cohorts, they will be considered
to have an unknown indication if they are present in one of the specified
OMOP CDM clinical tables. Otherwise, if they  are neither in an indication
cohort or a clinical table they will be considered as having no observed
indication.
}
\examples{
\donttest{
library(DrugUtilisation)
library(dplyr, warn.conflicts = FALSE)
library(CDMConnector)

cdm <- mockDrugUtilisation(source = "duckdb")

indications <- list(headache = 378253, asthma = 317009)
cdm <- generateConceptCohortSet(cdm = cdm,
                                conceptSet = indications,
                                name = "indication_cohorts")

cdm <- generateIngredientCohortSet(cdm = cdm,
                                   name = "drug_cohort",
                                   ingredient = "acetaminophen")

cdm$drug_cohort |>
  summariseIndication(
    indicationCohortName = "indication_cohorts",
    unknownIndicationTable = "condition_occurrence",
    indicationWindow = list(c(-Inf, 0))
  ) |>
  glimpse()
}

}
