% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/besmi_batch.R
\name{besmi_impute_single_dataset}
\alias{besmi_impute_single_dataset}
\title{Impute a single dataset from masked matrix path}
\usage{
besmi_impute_single_dataset(
  input_path,
  method = "lasso.norm",
  max_iterations = 5,
  imputation_convergence_threshold = 0.001,
  propagation_convergence_threshold = 0.001,
  distance_metric = "mae",
  output_dir = file.path(tempdir(), "DataFusionGDM_imputation"),
  full_dataset_path = NULL
)
}
\arguments{
\item{input_path}{Path to masked matrix RDS}

\item{method}{Imputation method ('lasso.norm' or 'KNN')}

\item{max_iterations}{Maximum iterations for iterative methods}

\item{imputation_convergence_threshold}{Convergence threshold for imputation metric}

\item{propagation_convergence_threshold}{Convergence threshold for propagation metric}

\item{distance_metric}{Distance metric name}

\item{output_dir}{Output directory for results (defaults to a temporary location)}

\item{full_dataset_path}{Optional path to a full matrix RDS used as ground truth}
}
\value{
Data frame of per-iteration metrics
}
\description{
Impute a single dataset from masked matrix path
}
