% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.sessions.R
\name{datashield.sessions}
\alias{datashield.sessions}
\title{R/DataSHIELD remote sessions}
\usage{
datashield.sessions(
  conns,
  async = TRUE,
  success = NULL,
  error = NULL,
  errors.print = getOption("datashield.errors.print", FALSE)
)
}
\arguments{
\item{conns}{\code{\link{DSConnection-class}} object or a list of \code{\link{DSConnection-class}}s.}

\item{async}{Whether the remote R/DataSHIELD session should be created asynchronously. When TRUE (default) the calls are parallelized over
the connections, when the connection supports that feature, with an extra overhead of requests.}

\item{success}{Callback function that will be called each time an R session has been created from a connection. 
The expected function signature is the connection/study name. Default is NULL (no callback).}

\item{error}{Callback function that will be called each time the R session creation request has failed. 
The expected function signature is the connection/study name and the error message. Default is NULL (no callback).}

\item{errors.print}{Boolean, whether to print datashield errors in the console or return a message indicating that they can be retrieved using `datashield.errors`.}
}
\description{
Ensure that the remote R sessions are up and running during the analysis.
}
\examples{
\dontrun{
# call sessions function on server side asynchronously
# i.e. each study connection will create a remote R session in parallel
datashield.sessions(conns)

# call sessions function with callback functions
result <- datashield.sessions(conns,
  success = function(server) {
    # do something with server's success
  },
  error = function(server, error) {
    # do something with server's error
  })
}

}
