% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DFanPC.R
\name{DFanPC}
\alias{DFanPC}
\title{Distributed Fan Principal Component Analysis}
\usage{
DFanPC(data, m, n1, K)
}
\arguments{
\item{data}{A numeric matrix containing the total dataset.}

\item{m}{An integer specifying the number of principal components.}

\item{n1}{An integer specifying the length of each data subset.}

\item{K}{An integer specifying the number of nodes.}
}
\value{
A list with the following components:
\describe{
  \item{AF}{List of estimated loading matrices for each node.}
  \item{DF}{List of diagonal residual variance matrices for each node.}
  \item{SigmahatF}{List of covariance matrices for each node.}
}
}
\description{
This function performs distributed Fan-type principal component analysis
on a numeric dataset split across multiple nodes.
}
\examples{
set.seed(123)
data <- matrix(rnorm(500), nrow = 100, ncol = 5)
DFanPC(data = data, m = 3, n1 = 20, K = 5)

}
