% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csp_cost_functions.R
\name{voxelize_points_mean_attributes}
\alias{voxelize_points_mean_attributes}
\title{helper function to voxelize a las element}
\usage{
voxelize_points_mean_attributes(las, res)
}
\arguments{
\item{las}{a lidR::LAS element}

\item{res}{voxel resolution in meter}
}
\value{
a las element with XYZ-coordinates as the voxel center and
X_gr,Y_gr,Z_gr as the center of gravity (mean point coordinates) as well as
all other numeric columns voxel mean values with their original name.
}
\description{
Calculate voxel mean values for all numeric attributes in the las@data table
including the XYZ-coordinates.
}
\examples{

# read example data
file = system.file("extdata", "beech.las", package="CspStandSegmentation")
las = lidR::readTLSLAS(file)
vox <- las |> voxelize_points_mean_attributes(1)


}
\seealso{
\code{\link[lidR]{voxelize_points}}
}
\author{
Julian Frey <julian.frey@wwd.uni-freiburg.de>
}
