% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windows.R
\name{window_symm}
\alias{window_symm}
\title{1D Symmetric Window Functions.}
\usage{
window_symm(x, name, params = c(1))
}
\arguments{
\item{x}{A vector or matrix of arguments of at least length 1. Each value must be between 0 and 1, inclusive.}

\item{name}{The name of the window. Options are: tukey, triangular, sine, power_sine, blackman, hann_poisson, welch.}

\item{params}{A vector of parameters for the windows. See the documentation below for the position of the parameters.}
}
\value{
A vector or matrix of values.
}
\description{
A symmetric window function in this context are traditional window functions, unlike the \link{window} functions.
This computes one of the symmetric window functions listed below, all of which are defined for \eqn{x \in [-1, 1],} and are 0 otherwise.
}
\details{
\strong{Tukey Window}.
The Tukey window is defined as
\deqn{w(x) = \frac{1}{2} + \frac{1}{2} \cos(\pi |x|) , x \in [-1, 1].}
The \code{params} argument is empty, see the example.

\strong{Triangular Window}.
The triangular window is given by
\deqn{w(x) = 1 - |x|, x \in [-1, 1].}
The \code{params} argument is empty, see the example.

\strong{Sine Window}.
The sine window is given by
\deqn{w(x) = 1 - \sin\left(\pi |x| / 2 \right), x \in [-1, 1].}
The \code{params} argument is empty, see the example.

\strong{Power Sine Window}.
The power sine window is given by
\deqn{w(x; a) = 1 - \sin^{a}(\pi |x| / 2), x \in [-1, 1], a > 0.}
The \code{params} argument is of the form \code{c(}\eqn{a}\code{)}

\strong{Blackman Window}.
The Blackman window is defined as
\deqn{w(x; a) = 1 +  ( (a - 1) / 2) + \frac{1}{2} \cos(\pi |x|) - \frac{a}{2} \cos(2 \pi |x|), x \in [-1, 1], a \in {R} .}
The \code{params} argument is of the form \code{c(}\eqn{a}\code{)}.
The standard value of \eqn{a} for this window is \eqn{0.16.}

\strong{Hann-Poisson Window}.
The Hann-Poisson window is defined as
\deqn{w(x; a) = 1 - \frac{1}{2} (1 - \cos(\pi |x|)) \exp( - (a \left|1 - |x| \right|) ) , x \in [-1, 1], a \in {R} .}
The \code{params} argument is of the form \code{c(}\eqn{a}\code{)}

\strong{Welch Window}.
The Welch window is given by
\deqn{w(x) = (|x| - 1)^2 , x \in [-1, 1] . }
The \code{params} argument is empty, see the example.
}
\examples{
x <- c(-0.6, -0.4, -0.2, 0, 0.2, 0.4, 0.6)
window_symm(x, "tukey")
window_symm(x, "triangular")
window_symm(x, "sine")
window_symm(x, "power_sine", c(0.7))
window_symm(x, "blackman", c(0.16))
window_symm(x, "hann_poisson", c(0.7))
window_symm(x, "welch")
curve(window_symm(x, "tukey"), from = -1, to = 1)
curve(window_symm(x, "triangular"), from = -1, to = 1)
curve(window_symm(x, "sine"), from = -1, to = 1)
curve(window_symm(x, "power_sine", c(0.7)), from = -1, to = 1)
curve(window_symm(x, "blackman", c(0.16)), from = -1, to = 1)
curve(window_symm(x, "hann_poisson", c(0.7)), from = -1, to = 1)
curve(window_symm(x, "welch"), from = -1, to = 1)
}
