% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sleep_cos.R
\name{sleep_cos}
\alias{sleep_cos}
\title{Estimates circadian cycle by cosinor fit of minute-level activity (period = 1440)}
\usage{
sleep_cos(clean_df, thr = 0.2)
}
\arguments{
\item{clean_df}{cleaned dataframe with cleaned_df$Activity.}

\item{thr}{Dichotomization threshold for fitted curve.}
}
\value{
A list with elements:
\describe{
\item{fitted}{fitted cosine curve.}
\item{label.cos}{dichotimized cosine curve}
\item{cos_para}{\code{c(Mesor, Amplitude, Acrophase)}.}
\item{rmse}{Root mean squared error between fitted cosine curve and data.}
}
}
\description{
Fits \eqn{C(t) = m + a \cos\{2\pi (t - \phi)/P\}} with period \eqn{P = 1440} minutes
to a rescaled activity series. Returns fitted curve, binary curve after
thresholding, and canonicalized parameters (non-negative amplitude).
MESOR (mesor)
The baseline or “midline” level around which the rhythm oscillates.
Units = same as actigraphy your data
Roughly the average activity across the cycle.
}
\details{
Amplitude (amp)
Half the peak-to-trough swing of the fitted rhythm.
Units is the same as actigraphy data.
Larger amplitude → stronger rhythmicity (bigger day–night contrast).
Negative amp will be flipped, and P/2 will be added to phase.
Acrophase (phase)
The timing of the peak of the fitted cosine.
Units is the epoch units of the data (e.g. minutes).
P=1440, interpret phase as minutes-of-day relative to your x origin.
}
\seealso{
\code{\link[=screen_wear]{screen_wear()}}, \code{\link[=sleep_detection]{sleep_detection()}}, \code{\link[=extract_sleep_metrics]{extract_sleep_metrics()}}
}
