% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conda_support.R
\name{restore_conda_env}
\alias{restore_conda_env}
\title{Restore Conda Environment}
\usage{
restore_conda_env(
  env_file = "conda_environment.yml",
  env_name = NULL,
  use_mamba = FALSE,
  force = FALSE
)
}
\arguments{
\item{env_file}{Character. Path to environment YAML file. Default "conda_environment.yml"}

\item{env_name}{Character. Name for the new environment. If NULL, uses name from file.}

\item{use_mamba}{Logical. Use mamba instead of conda. Default FALSE.}

\item{force}{Logical. Remove existing environment if it exists. Default FALSE.}
}
\value{
Logical. TRUE if successful, FALSE otherwise
}
\description{
Restore a conda environment from a previously exported environment file
}
\examples{
\dontrun{
# Restore environment from file
restore_conda_env("conda_environment.yml")

# Use mamba for faster installation
restore_conda_env("conda_environment.yml", use_mamba = TRUE)

# Force recreate if exists
restore_conda_env("conda_environment.yml", force = TRUE)
}
}
