#' compareExposures
#'
#' This function is used to check two signature sets in order to compare how the 
#' samples exposures differ across the two runs.
#'
#' @param reference Results from your reference analysis
#' @param toCompare Results from run that you want to compare to reference
#' @return Prints out the difference in signature exposures
#' @export
#' @examples
#' compareExposures(referenceExp, referenceExp)
compareExposures = function(reference, toCompare){
  #Finds the signature mapping
  mapping = matchSigs(reference$sigs,toCompare$sigs)
  
  difference = reference$sigExposure
  compExp = toCompare$sigExposure
  
  for (i in 1:nrow(difference)){
    map = mapping[i,2]
    diff = difference[i,]-compExp[map,colnames(difference)]
    difference[i,] = diff
  }
  
  pheatmap::pheatmap(difference,cluster_rows = FALSE, border_color = NA, breaks=seq(-1,1,.02),
                     main=paste0("Patient x Signature matrix Difference"))

  return(rowSums(difference)/ncol(difference))
}
