print.msmResult <- function(x, ...) {
  cf <- x$coefs
  fm <- x$formula
  lo <- x$CIlow
  up <- x$CIup

  cat("------------------------------------------------------------\n")
  cat(sprintf("Estimated marginal structural model %s:\n\n", deparse(fm)))
  cat(sprintf(
    "%-12s %12s %12s %12s\n", "Parameter", "Estimate", "CI (low)", "CI (up)"
  ))
  for (i in seq_along(cf)) {
    cat(sprintf(
      "%-12s %12.4f %12.4f %12.4f\n", names(cf)[i], cf[i], lo[i], up[i]
    ))
  }
  cat("\n")

  if (x$se == "glm") {
    cat("CIs based on se = 'glm' may result in undercoverage.\n")
    cat("Consider setting se = 'bootstrap' (and B > 0 in gformula).\n")
  }
  cat("------------------------------------------------------------\n")

  invisible(x)
}