% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{write_station_netcdf}
\alias{write_station_netcdf}
\title{Write station NetCDF (station x time)
Exports a simulated climate station dataset to a NetCDF file.}
\usage{
write_station_netcdf(
  df,
  out_nc = "simulated_station_climate.nc",
  fillvalue = -9999
)
}
\arguments{
\item{df}{station x time long dataframe returned by simulate_climate_series()}

\item{out_nc}{Output NetCDF filename}

\item{fillvalue}{Value used for missing entries}
}
\value{
Returns the file path invisibly.
}
\description{
Write station NetCDF (station x time)
Exports a simulated climate station dataset to a NetCDF file.
}
\examples{
stations <- create_stations(n = 3)
sim <- simulate_climate_series(stations)
tmp <- tempfile(fileext = ".nc")
write_station_netcdf(sim, tmp)
}
