
#' @rdname plot.bootstrapTest
#' @export
print.bootstrapTest <- function(x, ...){
  # print a nice layout=========================================================

  # dart emoji storing as 8 digits hex unicode: this dart_emoji_string = "\\U0001f3af"
  # dart_emoji_string <- sprintf("\\U%08x", utf8ToInt("🎯"))
  dart_emoji_string <- "\\U0001f3af"
  dart_emoji <- eval(parse(text = paste0('"', dart_emoji_string, '"')))
  welcome_message_name <- paste0("         ", dart_emoji, x$nameMethod, " Results", dart_emoji, "\n")
  equal_signs <- paste(rep("=", nchar(welcome_message_name) + 6), collapse = "")
  cat(welcome_message_name, equal_signs, "\n\n")

  # Highlighted row
  if (nrow(x$pvals_df) == 1) {
    row <- x$pvals_df

    # Get the true statistic
    if ("bootstrapTest_independence" %in% class(x)){
      true_stat <- x$true_stats[[row$type_norm]]
    } else if("bootstrapTest_GoF" %in% class(x)){

      true_stat <- switch(
        row$type_estimator_bootstrap,
        'MLE' = {
          x$true_stats["MLE"]
        },
        'MD-eq' = {
          x$true_stats["MD"]
        },
        'MD-cent' = {
          x$true_stats["MD"]
        },
        stop("Unknown 'type_estimator_bootstrap': ", row$type_estimator_bootstrap)
      )
    } else {
      true_stat <- x$true_stats
    }

    # Get quantiles
    row$quantile_95 <- sapply(row$list_stat_st, function(x) stats::quantile(x, 0.95))
    row$quantile_99 <- sapply(row$list_stat_st, function(x) stats::quantile(x, 0.99))

    cat("Performed test:\n")
    cat(sprintf("  Bootstrap type           : %s\n", row$type_boot))
    cat(sprintf("  Bootstrap repetitions    : %d\n", x$nBootstrap))
    cat(sprintf("  Type of test statistic   : %s\n", row$type_stat))
    if ("bootstrapTest_independence" %in% class(x)){
      cat(sprintf("  Type of norm used        : %s\n", row$type_norm))
    } else if ("bootstrapTest_regression" %in% class(x)){
      # store β as 4 digits hex unicode: this beta_string = "\\u03b2"
      # beta_string <- sprintf("\\u%04x", utf8ToInt("β"))
      beta_string <- "\\u03b2"
      beta_symbol <- eval(parse(text = paste0('"', beta_string, '"')))
      cat("  Slope coefficient",beta_symbol,"     :", x$beta, "\n")
    } else if ("bootstrapTest_GoF" %in% class(x)){
      cat("  Bootstrap estimator used :", row$type_estimator_bootstrap, "\n")
    }
    cat( paste0("  p-value                  : ", row$pvalues,"\n"))
    #cat(sprintf("  p-value                  : %.4f\n", row$pvalues))
    cat(sprintf("  True test statistic      : %.4f\n", true_stat))
    cat(sprintf("  Critical value at 5%%     : %.4f\n", row$ci_upper_95))
    cat(sprintf("  Critical value at 1%%     : %.4f\n", row$ci_upper_99))
    cat("\n")
  } else if ( nrow(x$pvals_df) >= 1 ) {
    # Print all testing information

    # Print the full p-values dataframe
    df <- x$pvals_df

    # Get quantiles
    df$quantile_95 <- sapply(df$list_stat_st, function(x) stats::quantile(x, 0.95))
    df$quantile_99 <- sapply(df$list_stat_st, function(x) stats::quantile(x, 0.99))

    # Print all test results
    cat("All test results:\n\n")
    print(df, row.names = FALSE)

    # Print true test statistics
    cat("\nTrue test statistics:\n")
    print(x$true_stats)
  }
}

