% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_compaction.R
\name{estimate_compaction}
\alias{estimate_compaction}
\title{Estimate Core Compaction}
\usage{
estimate_compaction(
  df = NULL,
  core = "core",
  sampler_length = "sampler_length",
  internal_distance = "internal_distance",
  external_distance = "external_distance"
)
}
\arguments{
\item{df}{A data.frame containing core properties.}

\item{core}{Character Name of the column identifying each core.}

\item{sampler_length}{Character Name of the column with the total length of the
sampler tube.}

\item{internal_distance}{Character Name of the column with the distance between
sampler top and core surface.}

\item{external_distance}{Character Name of the column with the distance between
sampler top and sediment surface.}
}
\value{
Returns the input data.frame with an additional 'compaction' column indicating
the estimated percentage of core compaction.
}
\description{
Estimates the percentage of core compaction using measurements
from a data.frame containing core properties. It computes a correction factor
based on sampler tube length, internal distance, and external distance, and
adds a 'compaction' column to the input data.frame with the calculated compaction
rate as a percentage.
}
\examples{
df <- estimate_compaction(
  core_comp,
  core = "core",
  sampler_length = "sampler_length",
  internal_distance = "internal_distance",
  external_distance = "external_distance"
)
head(df)


}
