% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roi.r
\name{roi_filter_threshold}
\alias{roi_filter_threshold}
\title{Filter Thermal Image by Temperature Thresholds}
\usage{
roi_filter_threshold(img_obj, threshold, use_processed = FALSE)
}
\arguments{
\item{img_obj}{A 'BioThermR' object.}

\item{threshold}{Numeric vector of length 2, e.g., \code{c(22, 38)}.
Defines the inclusive temperature range \code{[min, max]} to keep.
Use \code{Inf} for open upper bounds (e.g., \code{c(25, Inf)} keeps everything above 25 degrees Celsius).}

\item{use_processed}{Logical.
\itemize{
  \item If \code{FALSE} (default): The filter is applied to the \strong{raw} matrix, discarding any previous masks.
  \item If \code{TRUE}: The filter is applied to the \strong{processed} matrix, allowing for cumulative masking (e.g., refining an Otsu segmentation).
}}
}
\value{
A 'BioThermR' object with the \code{processed} matrix updated.
}
\description{
Masks the thermal image by retaining only pixels that fall within a specified
             temperature window. Pixels outside this range are set to \code{NA} (background).
}
\details{
This is the most fundamental segmentation method for thermal images.
         Since animals are typically warmer than their environment, a simple low-pass filter
         (e.g., keep > 22 degrees Celsius) is often sufficient to separate the subject from the cage.
         Open boundaries can be defined using \code{Inf} or \code{-Inf}.
}
\examples{
# Load raw data
img_obj <- system.file("extdata", "C05.raw", package = "BioThermR")
img <- read_thermal_raw(img_obj)

# Simple background removal: Keep everything above 24 degrees
img <- roi_filter_threshold(img, threshold = c(24, Inf))
}
