% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.r
\name{plot_roi_overlap}
\alias{plot_roi_overlap}
\title{Visualize ROI Overlap and Dice Coefficient}
\usage{
plot_roi_overlap(
  img_obj1,
  img_obj2,
  title = NULL,
  color = "green",
  alpha = 0.5,
  line_color = "white",
  palette = "inferno"
)
}
\arguments{
\item{img_obj1}{A 'BioThermR' object. Typically the \strong{Automated/Predicted} segmentation.
This object must contain the raw thermal matrix. Its mask will be plotted as a filled area.}

\item{img_obj2}{A 'BioThermR' object. Typically the \strong{Manual/Ground Truth} segmentation.
Its mask will be plotted as a contour outline. Dimensions must match \code{img_obj1}.}

\item{title}{String. Custom title for the plot. If \code{NULL} (default), the title shows "ROI overlap (DICE: X.XXX)".}

\item{color}{String. Fill color for the \code{img_obj1} mask. Default is "green".}

\item{alpha}{Numeric. Transparency level for the \code{img_obj1} mask (0 to 1). Default is 0.5.}

\item{line_color}{String. Line color for the \code{img_obj2} contour. Default is "white".}

\item{palette}{String. Color palette for the background thermal image (passed to \code{scale_fill_viridis_c}).
Default is "inferno".}
}
\value{
A \code{ggplot} object showing the overlay.
}
\description{
Visually compares two segmentation masks (ROIs) by overlaying them on the original thermal image.
             This function is primarily used for validation purposes: to compare an automated segmentation
             (filled layer) against a manual ground truth (contour line).
             It automatically calculates and displays the \strong{Dice Similarity Coefficient (DSC)} in the title.
}
\details{
The visualization consists of three layers:
         \enumerate{
           \item \strong{Background:} The raw thermal image from \code{img_obj1}.
           \item \strong{Prediction (img_obj1):} The processed mask from the first object, rendered as a semi-transparent filled raster (default green).
           \item \strong{Ground Truth (img_obj2):} The processed mask from the second object, rendered as a contour outline (default white).
         }
         The function calculates the Dice Similarity Coefficient (DSC) using the formula:
         \deqn{DSC = \frac{2 \times |X \cap Y|}{|X| + |Y|}}
         where X and Y are the set of pixels in the two masks. A DSC of 1 indicates perfect overlap.
}
\examples{
\donttest{
#' # Load raw data
img_obj <- system.file("extdata", "C05.raw", package = "BioThermR")
img <- read_thermal_raw(img_obj)
# Apply automated segmentation
img1 <- roi_segment_ebimage(img, keep_largest = TRUE)

# Simple background removal: Keep everything above 24 degrees
img2 <- roi_filter_threshold(img, threshold = c(33, Inf))

# Compare them
plot_roi_overlap(img_obj1 = img1,
                 img_obj2 = img2)
}
}
