/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import dr.inference.model.IntersectionBounds;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.model.TransposedBlockUpperTriangularMatrixParameter;

public class BlockUpperTriangularMatrixParameter
extends MatrixParameter {
    private int rowDim;
    private Bounds bounds = null;

    public TransposedBlockUpperTriangularMatrixParameter transposeBlock() {
        return TransposedBlockUpperTriangularMatrixParameter.recast(this.getVariableName(), this);
    }

    public BlockUpperTriangularMatrixParameter(String string, Parameter[] parameterArray, boolean bl) {
        super(string);
        int n;
        int n2 = parameterArray[parameterArray.length - 1].getSize();
        int n3 = parameterArray.length;
        for (n = 0; n < n3; ++n) {
            this.addParameter(parameterArray[n]);
        }
        this.rowDim = n2;
        if (bl) {
            for (n = 0; n < this.getColumnDimension(); ++n) {
                if (n >= this.getRowDimension()) continue;
                double[] dArray = new double[n + 1];
                double[] dArray2 = new double[n + 1];
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = Double.POSITIVE_INFINITY;
                    dArray2[i] = Double.NEGATIVE_INFINITY;
                }
                dArray2[n] = 0.0;
                this.getParameter(n).addBounds(new Parameter.DefaultBounds(dArray, dArray2));
            }
        }
    }

    @Override
    public int getRowDimension() {
        return this.rowDim;
    }

    @Override
    public void setRowDimension(int n) {
        this.rowDim = n;
    }

    @Override
    public double getParameterValue(int n, int n2) {
        if (!this.matrixCondition(n, n2)) {
            return 0.0;
        }
        return this.getParameter(n2).getParameterValue(this.getInnerDimension(n, n2));
    }

    protected int getRow(int n) {
        return n % this.getRowDimension();
    }

    protected int getColumn(int n) {
        return n / this.getRowDimension();
    }

    @Override
    public void setParameterValueQuietly(int n, int n2, double d) {
        if (this.matrixCondition(n, n2)) {
            this.getParameter(n2).setParameterValueQuietly(this.getInnerDimension(n, n2), d);
        }
    }

    @Override
    public void setParameterValue(int n, int n2, double d) {
        this.setParameterValueQuietly(n, n2, d);
        this.fireParameterChangedEvent();
    }

    @Override
    public void setParameterValue(int n, double d) {
        int n2;
        int n3 = this.getRow(n);
        if (this.matrixCondition(n3, n2 = this.getColumn(n))) {
            this.setParameterValue(n3, n2, d);
        }
    }

    boolean matrixCondition(int n, int n2) {
        return n >= n2;
    }

    @Override
    public double getParameterValue(int n) {
        int n2;
        int n3 = this.getRow(n);
        if (this.matrixCondition(n3, n2 = this.getColumn(n))) {
            return this.getParameterValue(n3, n2);
        }
        return 0.0;
    }

    @Override
    public void addBounds(Bounds<Double> bounds) {
        if (this.bounds == null) {
            this.bounds = new BUTMPBounds();
        }
        IntersectionBounds intersectionBounds = new IntersectionBounds(this.getDimension());
        intersectionBounds.addBounds(this.bounds);
        ((IntersectionBounds)this.bounds).addBounds(bounds);
    }

    @Override
    public Bounds<Double> getBounds() {
        if (this.bounds == null) {
            this.bounds = new BUTMPBounds();
        }
        return this.bounds;
    }

    protected int getInnerDimension(int n, int n2) {
        return n;
    }

    @Override
    public String getDimensionName(int n) {
        return this.getId() + "." + this.getRow(n) + "." + this.getColumn(n);
    }

    @Override
    public int getDimension() {
        return this.getRowDimension() * this.getColumnDimension();
    }

    private class BUTMPBounds
    implements Bounds<Double> {
        private BUTMPBounds() {
        }

        @Override
        public Double getUpperLimit(int n) {
            int n2;
            int n3 = BlockUpperTriangularMatrixParameter.this.getRow(n);
            if (BlockUpperTriangularMatrixParameter.this.matrixCondition(n3, n2 = BlockUpperTriangularMatrixParameter.this.getColumn(n))) {
                return BlockUpperTriangularMatrixParameter.this.getParameter(n2).getBounds().getUpperLimit(BlockUpperTriangularMatrixParameter.this.getInnerDimension(n3, n2));
            }
            return 0.0;
        }

        @Override
        public Double getLowerLimit(int n) {
            int n2;
            int n3 = BlockUpperTriangularMatrixParameter.this.getRow(n);
            if (BlockUpperTriangularMatrixParameter.this.matrixCondition(n3, n2 = BlockUpperTriangularMatrixParameter.this.getColumn(n))) {
                return BlockUpperTriangularMatrixParameter.this.getParameter(n2).getBounds().getLowerLimit(BlockUpperTriangularMatrixParameter.this.getInnerDimension(n3, n2));
            }
            return 0.0;
        }

        @Override
        public int getBoundsDimension() {
            return BlockUpperTriangularMatrixParameter.this.getDimension();
        }
    }
}

