/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import dr.geo.AbstractPolygon2D;
import dr.geo.GeoSpatialDistribution;
import dr.geo.MultiRegionGeoSpatialDistribution;
import dr.geo.Polygon2D;
import dr.inference.distribution.MultivariateDistributionLikelihood;
import dr.inference.model.Parameter;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

public class Polygon2DSampling
extends Polygon2D {
    private double fillValue;
    private double logFillValue;

    public Polygon2DSampling(double[] dArray, double[] dArray2, double d) {
        super(dArray, dArray2);
        this.fillValue = d;
    }

    public Polygon2DSampling(Element element, double d) {
        super(element);
        this.fillValue = d;
        this.logFillValue = Math.log(d);
    }

    @Override
    public double getProbability(Point2D point2D, boolean bl) {
        boolean bl2 = this.containsPoint2D(point2D);
        if (bl2) {
            return this.fillValue;
        }
        return 0.0;
    }

    @Override
    public double getLogProbability(Point2D point2D, boolean bl) {
        boolean bl2 = this.containsPoint2D(point2D);
        if (bl2) {
            return this.logFillValue;
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public void setFillValue(double d) {
        this.fillValue = d;
        this.logFillValue = Math.log(d);
    }

    @Override
    public double getFillValue() {
        return this.fillValue;
    }

    @Override
    public double getLogFillValue() {
        return this.logFillValue;
    }

    @Override
    public boolean hasFillValue() {
        return true;
    }

    public static void main(String[] stringArray) {
        List<AbstractPolygon2D> list = Polygon2D.readKMLFile(stringArray[0]);
        System.out.println("Reading from file: " + stringArray[0] + "\n");
        ArrayList<GeoSpatialDistribution> arrayList = new ArrayList<GeoSpatialDistribution>();
        boolean bl = false;
        AbstractPolygon2D abstractPolygon2D = list.get(0);
        System.out.println("Polygon 0: " + abstractPolygon2D.getFillValue());
        boolean bl2 = abstractPolygon2D.hasFillValue();
        if (list.size() > 1) {
            for (int i = 1; i < list.size(); ++i) {
                if (bl2 != list.get(i).hasFillValue()) {
                    throw new RuntimeException("Inconsistent fillValue attributes provided.");
                }
                System.out.println("Polygon " + i + ": " + list.get(i).getFillValue());
            }
        }
        if (bl2) {
            double d = 0.0;
            for (AbstractPolygon2D abstractPolygon2D2 : list) {
                d += abstractPolygon2D2.getFillValue();
            }
            if (Math.abs(d - 1.0) > 1.0E-12) {
                throw new RuntimeException("Fill values in " + stringArray[0] + " do not sum to 1 : " + d);
            }
            System.out.println("Provided sampling probabilities sum to 1.0");
        }
        bl = bl2;
        for (AbstractPolygon2D object2 : list) {
            arrayList.add(new GeoSpatialDistribution("", object2, true));
        }
        System.out.println("\nTesting sampling probabilities:");
        MultivariateDistributionLikelihood multivariateDistributionLikelihood = new MultivariateDistributionLikelihood(new MultiRegionGeoSpatialDistribution("", arrayList, false, bl));
        double[] dArray = new double[]{12.68379879, 108.12982178};
        Parameter.Default default_ = new Parameter.Default(dArray);
        multivariateDistributionLikelihood.addData(default_);
        System.out.println("logL = " + multivariateDistributionLikelihood.getLogLikelihood());
        System.out.println("L = " + Math.exp(multivariateDistributionLikelihood.getLogLikelihood()));
        default_.setParameterValue(0, 13.68379879);
        System.out.println("logL = " + multivariateDistributionLikelihood.getLogLikelihood());
        System.out.println("L = " + Math.exp(multivariateDistributionLikelihood.getLogLikelihood()));
        default_.setParameterValue(0, 12.68);
        System.out.println("logL = " + multivariateDistributionLikelihood.getLogLikelihood());
        System.out.println("L = " + Math.exp(multivariateDistributionLikelihood.getLogLikelihood()));
        default_.setParameterValue(0, 13.03387928);
        default_.setParameterValue(1, 108.51604462);
        System.out.println("logL = " + multivariateDistributionLikelihood.getLogLikelihood());
        System.out.println("L = " + Math.exp(multivariateDistributionLikelihood.getLogLikelihood()));
        default_.setParameterValue(0, 13.01971245);
        default_.setParameterValue(1, 108.56764221);
        System.out.println("logL = " + multivariateDistributionLikelihood.getLogLikelihood());
        System.out.println("L = " + Math.exp(multivariateDistributionLikelihood.getLogLikelihood()));
        default_.setParameterValue(0, 13.018);
        System.out.println("logL = " + multivariateDistributionLikelihood.getLogLikelihood());
        System.out.println("L = " + Math.exp(multivariateDistributionLikelihood.getLogLikelihood()));
    }
}

