% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_bayesglm.R
\name{fit_bayesglm}
\alias{fit_bayesglm}
\title{fit_bayesglm}
\usage{
fit_bayesglm(
  BOLD,
  design,
  nuisance = NULL,
  scrub = NULL,
  spatial,
  scale_BOLD = c("mean", "sd", "none"),
  Bayes = TRUE,
  hyperpriors = c("informative", "default"),
  ar_order = 6,
  ar_smooth = 5,
  aic = FALSE,
  n_threads = 4,
  return_INLA = c("trimmed", "full", "minimal"),
  verbose = 1,
  meanTol = 1e-06,
  varTol = 1e-06
)
}
\arguments{
\item{BOLD, design, nuisance}{Session-length list of numeric matrices/arrays,
each with volumes along the first dimension.}

\item{scrub}{Session-length list of spike regressors: numeric matrices, with
volumes along the first dimension, valued at 1 for scrubbed volumes and 0
otherwise.

Scrubbing is performed by incorporating spike regressors in the nuisance
matrix during nuisance regression (in a simultaneous framework), and then
removing the scrubbed timepoints from the resulting BOLD and design.}

\item{spatial}{Gives the spatial information:
\describe{
\item{surf}{A list of two: \code{vertices} \eqn{V \times 3} numeric matrix of vertex locations in XYZ coordinate space, and \code{faces}, \eqn{F \times 3} matrix of positive integers defining the triangular faces.}
\item{mask}{Mask of locations with valid data.}
}
For voxel data, a list of six:
\describe{
\item{label}{3D array of labeled locations to include in the model.}
\item{trans_mat}{Projection matrix to convert voxel indices to XYZ position. Can be \code{NULL}.}
\item{trans_units}{XYZ units. Can be \code{NULL}.}
\item{nbhd_order}{See documentation for \code{\link{BayesGLM}}.}
\item{buffer}{See documentation for \code{\link{BayesGLM}}.}
}}

\item{scale_BOLD}{Controls scaling the BOLD response at each location.
\describe{
\item{"mean":}{   Scale the data to percent local signal change.}
\item{"sd":}{   Scale the data by local standard deviation.}
\item{"none":}{   Center the data but do not scale it.}
}}

\item{Bayes}{Perform spatial Bayesian modeling? Default: \code{TRUE}. If
\code{FALSE}, only perform classical (massive univariate) modeling. (The classical GLM
result is always returned, whether \code{Bayes} is \code{TRUE} or \code{FALSE}.)}

\item{hyperpriors}{Should informative or default non-informative hyperpriors be assumed on SPDE hyperparameters?}

\item{ar_order}{(For prewhitening) The order of the autoregressive (AR) model
to use for prewhitening. If \code{0}, do not prewhiten. Default: \code{6}.

For multi-session modeling, note that a single AR model is used; its
coefficients will be the average estimate from each session.}

\item{ar_smooth}{(For prewhitening) The FWHM parameter for spatially
smoothing the coefficient estimates for the AR model to use for
prewhitening. Recall that
\eqn{\sigma = \frac{FWHM}{2*sqrt(2*log(2)}}. Set to \code{0} to not smooth
the estimates. Default: \code{5}.}

\item{aic}{(For prewhitening) Use the Akaike information criterion (AIC) to
select AR model orders between \code{0} and \code{ar_order}? Default:
\code{FALSE}.}

\item{n_threads}{The maximum number of threads to use for parallel
computations: prewhitening parameter estimation, and the inla-program model
estimation. Default: \code{4}. Note that parallel prewhitening requires the
\code{parallel} package.}

\item{return_INLA}{Return the INLA model object? (It can be large.) Use
\code{"trimmed"} (default) returns the results sufficient for
\code{\link{activations}} and \code{\link{BayesGLM2}}; \code{"minimal"}
returns enough for \code{\link{BayesGLM2}} but not
\code{\link{activations}}; \code{"full"} returns the full \code{inla}
output.}

\item{verbose}{\code{1} (default) to print occasional updates during model
computation; \code{2} for occasional updates as well as running INLA in
verbose mode (if \code{Bayes}), or \code{0} for no printed updates.}

\item{meanTol, varTol}{Tolerance for mean and variance of each data location.
Locations which do not meet these thresholds are masked out of the analysis.
Default: \code{1e-6} for both. Note that locations with a median not meeting
\code{meanTol} will also be masked out of the analysis (even if the mean is
above it).}
}
\value{
A \code{"BayesGLM"} object: a list with elements
\describe{
\item{INLA_model_obj}{The full result of the call to \code{INLA::inla}.}
\item{field_estimates}{The estimated coefficients for the Bayesian model.}
\item{result_classical}{Results from the classical model: field estimates, field standard error estimates, residuals, degrees of freedom, and the mask.}
\item{mesh}{The model mesh.}
\item{mask}{A mask of \code{mesh} indicating the locations inside \code{mesh}.}
\item{design}{The design matrix, after centering and scaling, but before any nuisance regression or prewhitening.}
\item{field_names}{The names of the fields.}
\item{session_names}{The names of the sessions.}
\item{hyperpar_posteriors}{Hyperparameter posterior densities.}
\item{theta_estimates}{Theta estimates from the Bayesian model.}
\item{posterior_Sig_inv}{For joint group modeling.}
\item{mu_theta}{For joint group modeling.}
\item{Q_theta}{For joint group modeling.}
\item{y}{For joint group modeling: The BOLD data after any centering, scaling, nuisance regression, or prewhitening.}
\item{X}{For joint group modeling: The design matrix after any centering, scaling, nuisance regression, or prewhitening.}
\item{prewhiten_info}{Vectors of values across locations: \code{phi} (AR coefficients averaged across sessions), \code{sigma_sq} (residual variance averaged across sessions), and AIC (the maximum across sessions).}
\item{call}{match.call() for this function call.}
}
}
\description{
Performs spatial Bayesian GLM for task fMRI activation
}
\section{INLA Requirement}{

This function requires the \code{INLA} package, which is not a CRAN package.
See \url{https://www.r-inla.org/download-install} for easy installation instructions.
}

