% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epi_synthetic.R
\docType{data}
\name{epi_synthetic}
\alias{epi_synthetic}
\title{Synthetic Epidemiological Time-Series Data}
\format{
A 200 × 1 numeric matrix containing the daily number of infection events.
}
\usage{
data(epi_synthetic)
}
\description{
A toy dataset generated from a stochastic SIR-type epidemic model using
the Doob–Gillespie algorithm. The transmission rate \code{beta} changes
once over time, resultiing in a single change-point in the infection
counts.
}
\details{
The simulation follows the stochastic simulation framework of:
Anderson, D. F. and Kurtz, T. G. (2015). \emph{Stochastic Analysis of
Biochemical Systems}. Springer International Publishing.

The simulation uses:
\itemize{
\item \code{S0 = 10000}, \code{I0 = 50}
\item \code{max_time = 200}
\item A piecewise-constant transmission rate vector with a change at time 130
\item Infection event times aggregated using \code{floor()}
}
}
\keyword{datasets}
