% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_time_out_success_altern.R
\name{do_time_out_success_altern}
\alias{do_time_out_success_altern}
\title{Alternative timeouts}
\usage{
do_time_out_success_altern(data, day_num, game_code, team_sel, data_to_list, verbose)
}
\arguments{
\item{data}{Prepared data from a given game.}

\item{day_num}{Day number.}

\item{game_code}{Game code.}

\item{team_sel}{One of the teams' names involved in the game.}

\item{data_to_list}{List with all the timeouts called from all coaches.}

\item{verbose}{Logical. Decide if information of the computations
must be provided or not.}
}
\value{
Data frame.  This is the meaning of the columns:
\itemize{
  \strong{day}: Day number.
  \strong{game_code}: Game code.
  \strong{team}: Name of the corresponding team and coach.
  \strong{times_out_requested}: Number of timeouts requested in the game.
  \strong{times_out_successful}: Number of timeouts that resulted in scoring.
  \strong{times_out_successful_perc}: Percentage of successful timeouts.
  \strong{points_scored}: Total of points achieved after the timeouts.
}
}
\description{
This is an alternative to \code{\link{do_time_out_success}} from season 2025-2026
because to my best of knowledge the timeouts are not directly collected from
web scraping and I have to check manually when they were called.
}
\seealso{
\code{\link{do_time_out_success}}
}
\author{
Guillermo Vinue
}
