% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_plot.df.R
\name{lm_plot.df}
\alias{lm_plot.df}
\title{Augment Model Data for Diagnostic Plots}
\usage{
lm_plot.df(mdl, parms = lm_plot.parms(mdl))
}
\arguments{
\item{mdl}{An object of class \code{lm}, representing the fitted linear model.}

\item{parms}{List of plotting parameters, usually from \code{lm_plot.parms()}.}
}
\value{
A data frame with augmented diagnostic variables, one row per observation.
}
\description{
Generates an augmented data frame from a linear model object, including fitted values, residuals, leverage, Cook's distance, prediction intervals, and outlier/influence flags. This function prepares model diagnostics for plotting.
}
\details{
The returned data frame contains key statistics for each observation:
\itemize{
  \item \code{.id}: Observation identifier
  \item \code{.sequence}: Sequence index
  \item \code{.obs}: Observed values
  \item \code{.fits}: Fitted/predicted values
  \item \code{.resid}: Residuals
  \item \code{.se.fit}: Estimated standard error of fitted (mean) value
  \item \code{.lower.pi}: Lower bound on 95\% prediction interval of fitted value
  \item \code{.upper.pi}: Upper bound on 95\% prediction interval of fitted value
  \item \code{.std.resid}: Standardized residuals
  \item \code{.stud.resid}: Studentized residuals
  \item \code{.cooksd}: Cook's distance
  \item \code{.hat}: Leverage (diagonal of the hat matrix)
  \item \code{.quantile}: Theoretical normal quantile of residuals
  \item \code{.is.outl}: Flag for residual outlier ("outl" or "reg")
  \item \code{.is.infl}: Flag for influential point ("infl" or "outl" or "reg")
  \item \code{.is.lev}: Flag for high leverage point ("lev" or "infl" or "reg")
}
}
\examples{
mdl <- lm(Sepal.Length ~ Sepal.Width, data = iris)
df <- lm_plot.df(mdl)
head(df)

}
\seealso{
\code{\link[stats]{influence}}, \code{\link[stats]{influence.measures}}, \code{\link[stats]{rstandard}}, \code{\link[stats]{rstudent}}, \code{\link{outlier}}
}
