#' Example Dataset for t-tests
#'
#' A small synthetic dataset included with *AssumpSure* for demonstrating 
#' independent and paired t-tests in the Continuous Data Tests tab.
#'
#' The file is stored in `inst/extdata/t-test.csv`.
#'
#' All values are synthetic, created only for demonstration; no human data were used,
#' and no ethical approval or consent is required.
#'
#' @format A CSV file with 85 rows and 5 columns:
#' \describe{
#'   \item{Plant}{Plant number.}
#'   \item{Type}{Treatment group.}
#'   \item{Treatment}{Treatment type.}
#'   \item{conc}{Treatment concentration.}
#'   \item{uptake}{Uptake value.}
#' }
#'
#' @source Simulated data generated by the author.
#'
#' @examples
#' read.csv(system.file("extdata", "t-test.csv", package = "AssumpSure"))
#' @name t-test
NULL
