







use crate::arraytraits::array_out_of_bounds;
use crate::imp_prelude::*;
use crate::NdIndex;





































pub trait IndexLonger<I>
{


    type Output;












    #[track_caller]
    fn index(self, index: I) -> Self::Output;














    #[track_caller]
    fn get(self, index: I) -> Option<Self::Output>;
















    unsafe fn uget(self, index: I) -> Self::Output;
}

impl<'a, 'b, I, A, D> IndexLonger<I> for &'b ArrayView<'a, A, D>
where
    I: NdIndex<D>,
    D: Dimension,
{
    type Output = &'a A;













    #[track_caller]
    fn index(self, index: I) -> &'a A
    {
        debug_bounds_check!(self, index);
        unsafe { &*self.get_ptr(index).unwrap_or_else(|| array_out_of_bounds()) }
    }

    fn get(self, index: I) -> Option<&'a A>
    {
        unsafe { self.get_ptr(index).map(|ptr| &*ptr) }
    }












    unsafe fn uget(self, index: I) -> &'a A
    {
        debug_bounds_check!(self, index);
        &*self.as_ptr().offset(index.index_unchecked(&self.strides))
    }
}

impl<'a, I, A, D> IndexLonger<I> for ArrayViewMut<'a, A, D>
where
    I: NdIndex<D>,
    D: Dimension,
{
    type Output = &'a mut A;













    #[track_caller]
    fn index(mut self, index: I) -> &'a mut A
    {
        debug_bounds_check!(self, index);
        unsafe {
            match self.get_mut_ptr(index) {
                Some(ptr) => &mut *ptr,
                None => array_out_of_bounds(),
            }
        }
    }









    fn get(mut self, index: I) -> Option<&'a mut A>
    {
        debug_bounds_check!(self, index);
        unsafe {
            match self.get_mut_ptr(index) {
                Some(ptr) => Some(&mut *ptr),
                None => None,
            }
        }
    }










    unsafe fn uget(mut self, index: I) -> &'a mut A
    {
        debug_bounds_check!(self, index);
        &mut *self
            .as_mut_ptr()
            .offset(index.index_unchecked(&self.strides))
    }
}
