% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xset_plots.R
\name{ipred_vs_ipred}
\alias{ipred_vs_ipred}
\alias{pred_vs_pred}
\title{Compare model predictions}
\usage{
ipred_vs_ipred(
  xpdb_s,
  ...,
  .inorder = FALSE,
  type = "pls",
  title = "Individual prediction comparison | @run",
  subtitle = "Ofv: @ofv, Eps shrink: @epsshk",
  caption = "@dir",
  tag = NULL,
  log = NULL,
  guide = TRUE,
  facets,
  .problem,
  quiet
)

pred_vs_pred(
  xpdb_s,
  ...,
  .inorder = FALSE,
  type = "pls",
  title = "Population prediction comparison | @run",
  subtitle = "Ofv: @ofv, Eps shrink: @epsshk",
  caption = "@dir",
  tag = NULL,
  log = NULL,
  guide = TRUE,
  facets,
  .problem,
  quiet
)
}
\arguments{
\item{xpdb_s}{<\code{xpose_set}> object}

\item{...}{See <\code{\link{two_set_dots}}>}

\item{.inorder}{See <\code{\link{two_set_dots}}>}

\item{type}{Passed to \code{xplot_scatter}}

\item{title}{Plot title}

\item{subtitle}{Plot subtitle}

\item{caption}{Plot caption}

\item{tag}{Plot tag}

\item{log}{Log scale covariate value?}

\item{guide}{Add guide line?}

\item{facets}{Additional facets}

\item{.problem}{Problem number}

\item{quiet}{Silence output}
}
\value{
The desired plot
}
\description{
For two models in an \code{xpose_set}, these functions are useful in comparing individual
and population predictions
}
\examples{

pheno_set \%>\%
  ipred_vs_ipred(run5,run15)

pheno_set \%>\%
  pred_vs_pred(run5,run15)

}
