% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{xportr_metadata}
\alias{xportr_metadata}
\title{Set variable specifications and domain}
\usage{
xportr_metadata(.df, metadata = NULL, domain = NULL, verbose = NULL)
}
\arguments{
\item{.df}{A data frame of CDISC standard.}

\item{metadata}{A data frame containing variable level metadata. See
'Metadata' section for details.}

\item{domain}{Appropriate CDISC dataset name, e.g. ADAE, DM. Used to subset
the metadata object.}

\item{verbose}{The action this function takes when an action is taken on the
dataset or function validation finds an issue. See 'Messaging' section for
details. Options are 'stop', 'warn', 'message', and 'none'}
}
\value{
\code{.df} dataset with metadata and domain attributes set
}
\description{
Sets metadata and/or domain for a dataset in a way that can be accessed by
other xportr functions. If used at the start of an xportr pipeline, it
removes the need to set metadata and domain at each step individually. For
details on the format of the metadata, see the 'Metadata' section for each
function in question.
}
\examples{

metadata <- data.frame(
  dataset = "test",
  variable = c("Subj", "Param", "Val", "NotUsed"),
  type = c("numeric", "character", "numeric", "character"),
  format = NA,
  order = c(1, 3, 4, 2)
)

adlb <- data.frame(
  Subj = as.character(123, 456, 789),
  Different = c("a", "b", "c"),
  Val = c("1", "2", "3"),
  Param = c("param1", "param2", "param3")
)

xportr_metadata(adlb, metadata, "test")

library(magrittr)

adlb \%>\%
  xportr_metadata(metadata, "test") \%>\%
  xportr_type() \%>\%
  xportr_order()
}
