% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ids_get.R
\name{ids_get}
\alias{ids_get}
\title{Fetch Data from the World Bank International Debt Statistics (IDS) API}
\usage{
ids_get(
  entities,
  series,
  counterparts = "WLD",
  start_year = 2000,
  end_year = NULL,
  progress = FALSE,
  geographies = lifecycle::deprecated()
)
}
\arguments{
\item{entities}{A character vector of entity identifiers representing
debtor countries and aggregates. Must use \code{entity_id} from
\link{ids_list_entities}:
\itemize{
\item For individual countries, use ISO3C codes (e.g., "GHA" for Ghana)
\item For aggregates, use World Bank codes (e.g., "LIC" for low income
countries)
The IDS database covers low and middle-income countries and related
aggregates only. Cannot contain NA values.
}}

\item{series}{A character vector of debt statistics series identifiers that
must match the \code{series_id} column from \link{ids_list_series}. Each
series represents a specific debt statistic (e.g., "DT.DOD.DECT.CD" for
total external debt stocks, "DT.TDS.DECT.CD" for debt service payments).
Cannot contain NA values.}

\item{counterparts}{A character vector of creditor identifiers that must
match the \code{counterpart_id} column from \link{ids_list_counterparts}. The
default "WLD" returns aggregated global totals across all creditors.
Common options:
\itemize{
\item "WLD" - World total (aggregated across all creditors)
\item "all" - Retrieve data broken down by all creditors
\item All identifiers are strings, but some are string-formatted numbers
(e.g., "730" for China, "907" for IMF), while others are alphabetic
codes (e.g., "BND" for bondholders)
Cannot contain NA values.
}}

\item{start_year}{A numeric value representing the starting year (default:
2000). This default is intended to reduce data volume. For historical
analysis, explicitly set to 1970 (the earliest year of data available).}

\item{end_year}{A numeric value representing the ending year (default: NULL).
Must be >= 1970 and cannot be earlier than start_year. If NULL, returns
data through the most recent available year. Some debt service-related
series include projections of debt service. For the 2024 data release,
debt service projections are available through 2031.}

\item{progress}{A logical value indicating whether to display progress
messages during data retrieval (default: FALSE).}

\item{geographies}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}
Superseded in favor of \code{entities}. If supplied, it will be mapped to
\code{entities} with a warning. Do \strong{not} use together with \code{entities}.}
}
\value{
A tibble containing debt statistics with the following columns:
\describe{
\item{entity_id}{The identifier for the debtor entity (e.g., "GHA"
for Ghana, "LIC" for low income countries)}
\item{series_id}{The identifier for the debt statistic series (e.g.,
"DT.DOD.DECT.CD" for total external debt stocks)}
\item{counterpart_id}{The identifier for the creditor (e.g., "WLD" for
world total, "730" for China)}
\item{year}{The year of the observation}
\item{value}{The numeric value of the debt statistic, standardized to the
units specified in the series definition (typically current US dollars)}
}
}
\description{
Retrieves standardized debt statistics from the World Bank's International
Debt Statistics (IDS) database, which provides comprehensive data on the
external debt of low and middle-income countries. The function handles
country identification, data validation, and unit standardization, making it
easier to conduct cross-country debt analysis and monitoring.
}
\section{Data Coverage and Validation}{

The IDS database provides detailed debt statistics for low and middle-income
countries, including:
\itemize{
\item Debt stocks and flows
\item Debt service and interest payments
\item Creditor composition
\item Terms and conditions of new commitments
}

To ensure valid queries:
\itemize{
\item Use \link{ids_list_entities} to find valid debtor entity codes
\item Use \link{ids_list_series} to explore available debt statistics
\item Use \link{ids_list_counterparts} to see available creditor codes
}
}

\examples{
\donttest{
# Get total external debt stocks for a single country from 2000 onward
ghana_debt <- ids_get(
  entities = "GHA",
  series = "DT.DOD.DECT.CD"  # External debt stocks, total
)

# Compare debt service metrics across income groups
income_groups <- ids_get(
  entities = c("LIC", "LMC", "UMC"),  # Income group aggregates
  series = "DT.TDS.DECT.CD",  # Total debt service
  start_year = 2010
)

# Analyze debt composition by major creditors
creditor_analysis <- ids_get(
  entities = c("KEN", "ETH"),  # Kenya and Ethiopia
  series = c(
    "DT.DOD.DECT.CD",  # Total external debt
    "DT.TDS.DECT.CD"   # Total debt service
  ),
  counterparts = c(
    "WLD",  # World total
    "730",  # China
    "907",  # IMF
    "BND"   # Bondholders
  ),
  start_year = 2015
)
}

}
\seealso{
\itemize{
\item \code{ids_list_entities()} for available debtor entity codes
\item \code{ids_list_series()} for available debt statistics series codes
\item \code{ids_list_counterparts()} for available creditor codes
}
}
