% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waffle.R
\name{waffle}
\alias{waffle}
\title{Make waffle (square pie) charts}
\usage{
waffle(
  parts,
  rows = 10,
  keep = TRUE,
  xlab = NULL,
  title = NULL,
  colors = NA,
  size = 2,
  flip = FALSE,
  reverse = FALSE,
  equal = TRUE,
  pad = 0,
  use_glyph = FALSE,
  glyph_size = 12,
  glyph_font = "Font Awesome 5 Free Solid",
  glyph_font_family = "FontAwesome5Free-Solid",
  legend_pos = "right"
)
}
\arguments{
\item{parts}{named vector of values or a data frame to use for the chart}

\item{rows}{number of rows of blocks}

\item{keep}{keep factor levels (i.e. for consistent legends across waffle plots)}

\item{xlab}{text for below the chart. Highly suggested this be used to
give the "1 sq == xyz" relationship if it's not obvious}

\item{title}{chart title}

\item{colors}{exactly the number of colors as values in \code{parts.}
If omitted, Color Brewer "Set2" colors are used.}

\item{size}{width of the separator between blocks (defaults to \code{2})}

\item{flip}{flips x & y axes}

\item{reverse}{reverses the order of the data}

\item{equal}{by default, waffle uses \code{coord_equal}; this can cause
layout problems, so you an use this to disable it if you are using
ggsave or knitr to control output sizes (or manually sizing the chart)}

\item{pad}{how many blocks to right-pad the grid with}

\item{use_glyph}{use specified glyph; if using built-in Font Awesome, can be
the glyph name; otherwise, it must be the unicode glyph from the custom
font the caller is using.}

\item{glyph_size}{size of the Font Awesome font}

\item{glyph_font, glyph_font_family}{if \code{use_glyph} is not \code{FALSE},
the \code{gplyph_font} will be looked up in the font database and
the \code{glpyph_font_family} used as the \code{family} parameter to ggplot for
font display since fonts in R, Python and anythign that relies on
legacy font C libraries are woefully messed up. You may need to adjust
either of these "font" parameters depending on your system & OS version
due to the fact that font names are different even between OS versions
(sometimes).\cr
\cr
The package comes with Font Awesome and helpers for it. Use of any other fonts
requires the caller to be familiar with using fonts in R. NOT ALL FONTS
will work with ggplot2 and definitely not under all graphics devices
for ggplot2.}

\item{legend_pos}{position of legend}
}
\description{
Given a named vector or a data frame, this function will return a ggplot object that
represents a waffle chart of the values. The individual values will be
summed up and each that will be the total number of squares in the grid.
You can perform appropriate value transformation ahead of time to get the
desired waffle layout/effect.
}
\details{
If a data frame is used, the first two columns should contain the desired names
and the values, respectively.

If the vector is not named or only partially named, capital letters will be
used instead.

It is highly suggested that you limit the number of elements
to plot, just like you should if you ever got wasted and decided that a
regular pie chart was a good thing to create and then decide to be totally
evil and make one to pollute this beautiful world of ours.

Chart title and x-axis labels are optional, especially if you'll just be
exporting to another program for use/display.

If you specify a string (vs \code{FALSE}) to \code{use_glyph} the function
will map the input to a Font Awesome glyph name and use that glyph for the
tile instead of a block (making it more like an isotype pictogram than a
waffle chart). You'll need to install Font Awesome 5 and use
the \code{extrafont} package to
be able to use Font Awesome 5 glyphs. Sizing is also up to the user since
fonts do not automatically scale with graphic resize.

Glyph idea inspired by Ruben C. Arslan (@_r_c_a)
}
\note{
You MUST use the Font Awesome 5 fonts bundled with the package.
See \code{\link[=install_fa_fonts]{install_fa_fonts()}}.
}
\examples{
parts <- c(80, 30, 20, 10)
waffle(parts, rows=8)

parts <- data.frame(
  names = LETTERS[1:4],
  vals = c(80, 30, 20, 10)
)

waffle(parts, rows=8)

# library(extrafont)
# waffle(parts, rows=8, use_glyph="shield")

parts <- c(One=80, Two=30, Three=20, Four=10)
chart <- waffle(parts, rows=8)
# print(chart)
}
