% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server_bind.R
\name{bind_both_table}
\alias{bind_both_table}
\title{Bind both table}
\usage{
bind_both_table(dfLeft_summ, dfRight_summ, y_left, y_right)
}
\arguments{
\item{dfLeft_summ}{A summarized dataframe to be joined}

\item{dfRight_summ}{A summarized dataframe to be joined}

\item{y_left}{A character vector specifying the column to be relocated before y_right}

\item{y_right}{A character vector specifying the column after which y_left will be relocated}
}
\value{
A dataframe obtained by joining dfLeft_summ and dfRight_summ, with y_left relocated before y_right
}
\description{
This function joins two summarized dataframes and relocates y_left before y_right.
The function also sets the VIS_Groep value to 'left' for the right dataframe.
}
\examples{
df1 <- data.frame(
  VIS_Groep = "a",
  x = c("a", "b"),
  y1 = 1:2
)
df2 <- data.frame(
  VIS_Groep = "b",
  x = c("a", "b"),
  y2 = 3:4
)

df_both <- bind_both_table(df1, df2, "y1", "y2")

}
