% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ctd_dat_combine}
\alias{ctd_dat_combine}
\title{VPR CTD data}
\format{
A dataframe with 15 variables
\describe{
\item{time_ms}{Time stamp when ROI was collected (milliseconds)}
\item{conductivity}{Conductivity collected by the VPR CTD}
\item{pressure}{Pressure measured from the VPR CTD in decibars}
\item{temperature}{Temperature measured from the VPR CTD in celsius}
\item{salinity}{Salinity measured from the VPR CTD}
\item{fluor_ref}{A reference fluorescence baseline provided in millivolts by the VPR CTD for calibrating fluorescence_mv data}
\item{fluorescence_mv}{Fluorescence in millivolts from the VPR CTD (uncalibrated)}
\item{turbidity_ref}{A reference turbidity baseline provided in millivolts for calibrating turbidity_mv}
\item{turbidity_mv}{Turbidity in millivolts from the VPR CTD (uncalibrated)}
\item{altitude_NA}{Altitude data from the VPR CTD}
\item{day}{Day on which VPR data was collected (from AutoDeck)}
\item{hour}{Hour during which VPR data was collected (from AutoDeck)}
\item{station}{Station idnetifier provided during processing}
\item{sigmaT}{Density caluclated from temperature, pressure and salinity data}
\item{depth}{Depth in metres caluclated form pressure}
}
}
\usage{
ctd_dat_combine
}
\description{
A dataframe including all CTD parameters from the VPR CTD,
produced by \code{\link{vpr_ctd_read}}
}
\keyword{datasets}
