% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_interaction.R
\name{compute_interaction}
\alias{compute_interaction}
\title{Compute interaction disproportionality}
\usage{
compute_interaction(
  .data,
  y,
  x,
  z,
  alpha = 0.05,
  na_format = "-",
  dig = 2,
  export_raw_values = FALSE,
  min_n_obs = 0
)
}
\arguments{
\item{.data}{The data.table to compute from.}

\item{y}{A character vector, one or more variable to explain.}

\item{x}{A character vector, one or more explaining variable.}

\item{z}{A character vector, one or more explaining variable.}

\item{alpha}{Alpha risk.}

\item{na_format}{Character string to fill NA values in ror and ci legends.}

\item{dig}{Number of digits for rounding (this argument is passed to \code{cff})}

\item{export_raw_values}{A logical. Should the raw values be exported?}

\item{min_n_obs}{A numeric, compute disproportionality only for pairs
with at least \code{min_n_obs} cases.}
}
\value{
A data.table, with Information Component (IC) of interaction,
and its credibility interval (at \code{1 - alpha}).
Significance as \code{signif_ic}, if \code{export_raw_values} is TRUE).

A data.table with columns
\itemize{
\item \code{y}, \code{x} and \code{z}, same as input
\item \code{n_obs} the number of observed cases
\item \code{n_exp} the number of expected cases
\item \code{ic} the Information Component
\item \code{ic_tail} the tail probability of the IC
\item \code{ci_level} the confidence interval level
\item Additional columns, if \code{export_raw_values} is \code{TRUE}:
\item \code{a}, \code{b}, \code{c}, \code{d} the counts in the contingency table
\item \code{signif_ic} the significance of the Information Component
\item Additional columns, if \code{export_raw_values} is \code{TRUE}:
\item \verb{n_*} the counts of each setting
\item \code{signif_ic} the significance of the Information Component
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Returns the information
component of interaction for a set of 3 variables,
usually 2 drugs and an adr.
}
\details{
Significance is similar to usual disproportionality (see \code{\link[=compute_dispro]{compute_dispro()}}).
}
\examples{
# Interaction on reporting of colitis with ipilimumab and nivolumab
demo <-
  demo_ |>
  add_drug(
    d_code = ex_$d_drecno,
    drug_data = drug_
  ) |>
  add_adr(
    a_code = ex_$a_llt,
    adr_data = adr_
  )

demo |>
  compute_interaction(
    y = "a_colitis",
    x = "nivolumab",
    z = "ipilimumab"
  )

}
\seealso{
\code{\link[=compute_dispro]{compute_dispro()}}, \code{\link[=compute_or_mod]{compute_or_mod()}}, \code{\link[=add_drug]{add_drug()}}, \code{\link[=add_adr]{add_adr()}}
}
\keyword{disproportionality}
