% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defcon.R
\name{defcon}
\alias{defcon}
\title{DEtection of Frequency CONtamination}
\usage{
defcon(file, rmCNV = FALSE, cnvobj = NULL, config = NULL,
  class_model = NULL, regression_model = NULL)
}
\arguments{
\item{file}{VCF input object}

\item{rmCNV}{Remove CNV regions, default is FALSE}

\item{cnvobj}{CNV object, default is NULL}

\item{config}{config information of parameters. A default set is generated as part of the model and is included in a model object, which contains}

\item{class_model}{An SVM classification model}

\item{regression_model}{An SVM regression model}
}
\value{
A list containing (1) stat: a data frame with all statistics for contamination estimation; (2) result: contamination estimation (Class = 0, pure; Class = 1, contaminated)
}
\description{
Detects whether a sample is contaminated another sample of its same species. The input file should be in vcf format.
}
\examples{
data(vcf_example)
result <- defcon(file = vcf_example)
}
