% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fa_crownseg.R
\name{chmseg_FT}
\alias{chmseg_FT}
\title{Watershed segmentation based on 'ForestTools'}
\usage{
chmseg_FT(
  treepos = NULL,
  chm = NULL,
  minTreeAlt = 2,
  format = "polygons",
  winRadius = 1.5,
  verbose = FALSE
)
}
\arguments{
\item{treepos}{\code{raster*}. The positions of the estimated top of trees. The function will generally produce a
number of crown segments equal to the number of treetops.}

\item{chm}{raster*. Canopy height model in \code{raster} format. Should be the same that was used to create
the input for \code{treepos}.}

\item{minTreeAlt}{numeric. The minimum height value for a \code{CHM} pixel to be considered as part of a crown segment.
All \code{chm} pixels beneath this value will be masked out. Note that this value should be lower than the minimum
height of \code{treepos}.}

\item{format}{character. Format of the function's output. Can be set to either 'raster' or 'polygons'.}

\item{winRadius}{numeric the fixed radius written in the SPDF of the tree top file if not generated by Foresttools}

\item{verbose}{to be quiet FALSE}
}
\value{
sp* object
}
\description{
'ForestTools' segmentation of individual tree crowns based on a canopy height model and initial seeding points (trees). Very fast algorithm based on the imagr watershed algorithm.
Andrew Plowright: R package \href{https://CRAN.R-project.org/package=ForestTools}{'ForestTools'}
}
\examples{
 require(uavRst)
## get the data
 data(chm_seg)
 data(trp_seg)
## you may create the Foresttools tree tops
## otherwise the raster is transformed to a SPDF according to the FT format   
#trp <- ForestTools::vwf(chm_seg[[1]], winFun = function(x){x * 0.06 + 0.5}, minHeight = 2)
## segmentation
crownsFT <- chmseg_FT(chm = chm_seg[[1]],
                       treepos = trp_seg[[1]],
                       format = "polygons",
                       minTreeAlt = 23,
                       winRadius = 1.5,
                       verbose = FALSE)

## Visualisation
raster::plot(crownsFT)

}
