% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node-metadata}
\alias{node-metadata}
\alias{node_is_named}
\alias{node_is_missing}
\alias{node_is_extra}
\alias{node_is_error}
\alias{node_has_error}
\title{Node metadata}
\usage{
node_is_named(x)

node_is_missing(x)

node_is_extra(x)

node_is_error(x)

node_has_error(x)
}
\arguments{
\item{x}{\verb{[tree_sitter_node]}

A node.}
}
\value{
\code{TRUE} or \code{FALSE}.
}
\description{
These functions return metadata about the current node.
\itemize{
\item \code{node_is_named()} reports if the current node is named or anonymous.
\item \code{node_is_missing()} reports if the current node is \code{MISSING}, i.e.
if it was implied through error recovery.
\item \code{node_is_extra()} reports if the current node is an "extra" from the
grammar.
\item \code{node_is_error()} reports if the current node is an \code{ERROR} node.
\item \code{node_has_error()} reports if the current node is an \code{ERROR} node, or if
any descendants of the current node are \code{ERROR} or \code{MISSING} nodes.
}
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "fn <- function() { 1 + 1 }"
tree <- parser_parse(parser, text)
node <- tree_root_node(tree)

node <- node_child(node, 1)

fn <- node_child(node, 1)
operator <- node_child(node, 2)

fn
node_is_named(fn)

operator
node_is_named(operator)

# Examples of `TRUE` cases for these are a bit hard to come up with, because
# they are dependent on the exact state of the grammar and the error recovery
# algorithm
node_is_missing(node)
node_is_extra(node)
\dontshow{\}) # examplesIf}
}
