% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold.R
\name{ROC.plot}
\alias{ROC.plot}
\title{ROC.plot}
\usage{
ROC.plot(prediction, real, .add = FALSE, color = "red")
}
\arguments{
\item{prediction}{A vector of real numbers representing the prediction score of a category.}

\item{real}{A vector with the real categories of the individuals in the prediction.}

\item{.add}{A logical value that indicates if it should be added to an existing graph}

\item{color}{Color of the ROC curve in the graph}
}
\value{
A plot object.
}
\description{
Function that plots the ROC curve of a prediction with only 2 categories.
}
\examples{

iris2 <- dplyr::filter(iris,(Species == "setosa") | (Species == "virginica"))
iris2$Species <- factor(iris2$Species,levels = c("setosa","virginica"))
sam <- sample(1:100,20)
ttesting <- iris2[sam,]
ttraining <- iris2[-sam,]
model <- train.rpart(Species~.,ttraining)
prediction.prob <- predict(model,ttesting, type = "prob")
ROC.plot(prediction.prob$prediction[,2],ttesting$Species)

}
\seealso{
\code{\link[ROCR]{prediction}} and \code{\link[ROCR]{performance}}
}
