% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.R
\name{train.knn}
\alias{train.knn}
\title{train.knn}
\usage{
train.knn(
  formula,
  data,
  kmax = 11,
  ks = NULL,
  distance = 2,
  kernel = "optimal",
  ykernel = NULL,
  scale = TRUE,
  contrasts = c(unordered = "contr.dummy", ordered = "contr.ordinal"),
  ...
)
}
\arguments{
\item{formula}{A formula object.}

\item{data}{Matrix or data frame.}

\item{kmax}{Maximum number of k, if ks is not specified.}

\item{ks}{A vector specifying values of k. If not null, this takes precedence over kmax.}

\item{distance}{Parameter of Minkowski distance.}

\item{kernel}{Kernel to use. Possible choices are "rectangular" (which is standard unweighted knn), "triangular", "epanechnikov" (or beta(2,2)),
"biweight" (or beta(3,3)), "triweight" (or beta(4,4)), "cos", "inv", "gaussian" and "optimal".}

\item{ykernel}{Window width of an y-kernel, especially for prediction of ordinal classes.}

\item{scale}{logical, scale variable to have equal sd.}

\item{contrasts}{A vector containing the 'unordered' and 'ordered' contrasts to use.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A object knn.prmdt with additional information to the model that allows to homogenize the results.
}
\description{
Provides a wrapping function for the \code{\link[kknn]{train.kknn}}.
}
\note{
the parameter information was taken from the original function \code{\link[kknn]{train.kknn}}.
}
\examples{

data("iris")

n <- seq_len(nrow(iris))
.sample <- sample(n, length(n) * 0.75)
data.train <- iris[.sample,]
data.test <- iris[-.sample,]

modelo.knn <- train.knn(Species~., data.train)
modelo.knn
prob <- predict(modelo.knn, data.test, type = "prob")
prob
prediccion <- predict(modelo.knn, data.test, type = "class")
prediccion
confusion.matrix(data.test, prediccion)

}
\references{
Klaus Schliep and Klaus Hechenbichler (2016). kknn: Weighted k-Nearest Neighbors.
R package version 1.3.1. https://CRAN.R-project.org/package=kknn
}
\seealso{
The internal function is from package \code{\link[kknn]{train.kknn}}.
}
