% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preprocessing.R
\name{detect_outliers_mad}
\alias{detect_outliers_mad}
\title{Detect Outliers Using Median Absolute Deviation}
\usage{
detect_outliers_mad(data, k = 3)
}
\arguments{
\item{data}{Numeric vector of values to analyze}

\item{k}{Numeric threshold for outlier detection (default: 3).}
}
\value{
A list containing:
\item{outlier_mask}{Logical vector indicating outliers}
\item{stats}{List containing:
\itemize{
\item median: Median of data
\item mad: Median absolute deviation
\item n_outliers: Number of outliers detected
}
}#' @importFrom stats median mad
}
\description{
Detects outliers in numeric data using the Median Absolute Deviation (MAD) method.
This robust method is less sensitive to extreme values than standard deviation
and works well for non-normally distributed data.
}
\details{
The function calculates the median and MAD of the data and identifies points
that are more than \code{k} MADs from the median as outliers.
}
\keyword{internal}
