% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_metrics.R
\name{error_calculator_comparison}
\alias{error_calculator_comparison}
\title{Calculate comprehensive error metrics between predicted and true distances}
\usage{
error_calculator_comparison(p_dist_mat, truth_matrix, input_matrix)
}
\arguments{
\item{p_dist_mat}{Matrix of predicted distances}

\item{truth_matrix}{Matrix of true distances}

\item{input_matrix}{Matrix of input distances (may contain NAs and is used to find the NAs' pattern)}
}
\value{
A list containing:
\item{report_df}{A \code{data.frame} with detailed error metrics for each point-pair, including \code{InSampleError}, \code{OutSampleError}, and their percentage-based counterparts.}
\item{Completeness}{A single numeric value representing the completeness statistic, which is the fraction of validation points for which a prediction could be made.}
}
\description{
Computes various error metrics including in-sample and out-of-sample errors,
and Completeness statistics for model evaluation.
}
\details{
Input requirements and constraints:
\itemize{
\item Matrices must have matching dimensions
\item Row and column names must be consistent between matrices
\item NAs are allowed and handled appropriately
\item Threshold indicators (< or >) in input matrix are processed correctly
}
}
