% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{build_model}
\alias{build_model}
\alias{build_model.default}
\alias{build_model.matrix}
\alias{build_model.stslist}
\alias{build_model.data.frame}
\alias{build_model.tna_data}
\alias{build_model.tsn}
\alias{build_model.tsn_ews}
\alias{tna}
\alias{ftna}
\alias{ctna}
\alias{atna}
\alias{tsn}
\title{Build a Transition Network Analysis Model}
\usage{
build_model(
  x,
  type = "relative",
  scaling = character(0L),
  cols = tidyselect::everything(),
  params = list(),
  inits,
  begin_state,
  end_state
)

\method{build_model}{default}(
  x,
  type = "relative",
  scaling = character(0L),
  cols = tidyselect::everything(),
  params = list(),
  inits,
  begin_state,
  end_state
)

\method{build_model}{matrix}(
  x,
  type = "relative",
  scaling = character(0L),
  cols = tidyselect::everything(),
  params = list(),
  inits,
  begin_state,
  end_state
)

\method{build_model}{stslist}(
  x,
  type = "relative",
  scaling = character(0L),
  cols = tidyselect::everything(),
  params = list(),
  inits,
  begin_state,
  end_state
)

\method{build_model}{data.frame}(
  x,
  type = "relative",
  scaling = character(0L),
  cols = tidyselect::everything(),
  params = list(),
  inits,
  begin_state,
  end_state
)

\method{build_model}{tna_data}(
  x,
  type = "relative",
  scaling = character(0L),
  cols = tidyselect::everything(),
  params = list(),
  inits,
  begin_state,
  end_state
)

\method{build_model}{tsn}(
  x,
  type = "relative",
  scaling = character(0L),
  cols = tidyselect::everything(),
  params = list(),
  inits,
  begin_state,
  end_state
)

\method{build_model}{tsn_ews}(
  x,
  type = "relative",
  scaling = character(0L),
  cols = tidyselect::everything(),
  params = list(),
  inits,
  begin_state,
  end_state
)

tna(x, ...)

ftna(x, ...)

ctna(x, ...)

atna(x, ...)

tsn(x, ...)
}
\arguments{
\item{x}{A \code{stslist} (from \code{TraMineR}), \code{data.frame}, a \code{matrix}, or
a \code{tna_data} object (see \code{\link[=prepare_data]{prepare_data()}}).
For \code{stslist} and \code{data.frame} objects \code{x}
should describe a sequence of events or states to be used for building the
Markov model.  If \code{x} is a matrix, it is assumed that the element on row
\code{i} and column \code{j} is the weight of the edge representing the transition
from state \code{i} to state \code{j}. If \code{x} is a \code{data.frame}, then
it must be in wide format (see \code{cols} on how to define columns for the
time points).}

\item{type}{A \code{character} string describing the weight matrix type.
Currently supports the following types:
\itemize{
\item \code{"relative"} for relative frequencies (probabilities, the default)
\item \code{"frequency"} for frequencies.
\item \code{"co-occurrence"} for co-occurrences.
\item \code{"n-gram"} for n-gram transitions. Captures higher-order transitions by
considering sequences of n states, useful for identifying longer
patterns.
\item \code{"gap"} allows transitions between non-adjacent states, with
transitions weighted by the gap size.
\item \code{"window"} creates transitions between all states within a
sliding window, capturing local relationships
(several sequences together).
\item \code{"reverse"} considers the sequences in reverse order
(resulting in what is called a reply network in some contexts).
The resulting weight matrix is the transpose of the \code{"frequency"}
option.
\item \code{"attention"} aggregates all downstream pairs of states with an
exponential decay for the gap between states. The parameter \code{lambda}
can be used to control the decay rate (the default is 1)-
}}

\item{scaling}{A \code{character} vector describing how to scale the weights
defined by \code{type}. When a vector is provided, the scaling options are
applied in the respective order. For example, \code{c("rank", "minmax")} would
first compute the ranks, then scale them to the unit interval using
min-max normalization. An empty vector corresponds to no scaling.
Currently supports the following options:
\itemize{
\item \code{"minmax"} performs min-max normalization to scale the weights to the
unit interval. Note that if the smallest weight is positive, it
will be zero after scaling.
\item \code{"max"} Multiplies the weights by the reciprocal of the largest weight
to scale the weights to the unit interval. This options preserves
positive ranks, unlike \code{"minmax"} when all weights are positive.
\item \code{"rank"} Computes the ranks of the weights using \code{\link[base:rank]{base::rank()}} with
\code{ties.method = "average"}.
}}

\item{cols}{An \code{expression} giving a tidy selection of columns that should
be considered as sequence data. By default, all columns are used. Ignored
for \code{matrix}, \code{tna_data} and \code{tsn} type \code{x}.}

\item{params}{A \code{list} of additional arguments for models of specific
\code{type}. The potential elements of this list are:
\itemize{
\item \code{n_gram}: An \code{integer} for n-gram transitions specifying the number of
adjacent events. The default value is 2.
\item \code{max_gap}: An \code{integer} for the gap-allowed transitions specifying the
largest allowed gap size. The default is 1.
\item \code{window_size}: An \code{integer} for the sliding window transitions
specifying the window size. The default is 2.
\item \code{weighted}: A \code{logical} value. If \code{TRUE}, the transitions
are weighted by the inverse of the sequence length. Can be used for
frequency, co-occurrence and reverse model types. The default is
\code{FALSE}.
\item \code{direction}: A \code{character} string specifying the direction of attention
for models of \code{type = "attention"}. The available options are
\code{"backward"}, \code{"forward"}, and \code{"both"}, for backward attention,
forward attention, and bidirectional attention, respectively.
The default is \code{"forward"}.
\item \code{decay}: A \code{function} that specifies the decay of the weights between
two time points at a specific distance. The function should take three
arguments: \code{i}, \code{j} and \code{lambda}, where \code{i} and \code{j} are \code{numeric}
vectors of time values, and \code{lambda} is  a \code{numeric} value for the
decay rate. The function should return a \code{numeric} vector of weights.
The default is \code{function(i, j, lambda) exp(-abs(i - j) / lambda)}.
\item \code{lambda}: A \code{numeric} value for the decay rate. The default is 1.
\item \code{time}: A \code{matrix} or a \code{data.frame} providing the time values
for each sequence and at time index. For \code{tna_data} objects, this can
also be a logical value, where \code{TRUE} will use the \code{time_data} element
of \code{x} for the time values. \code{Date} values are converted to \code{numeric}.
\item \code{duration}: A \code{matrix} or a \code{data.frame} providing the
time spent in each state for each sequence and time index.
This is an alternative to \code{time}.
}}

\item{inits}{An optional \code{numeric} vector of initial state probabilities
for each state. The vector will be scaled to unity.
Ignored if \code{x} is not a \code{matrix}.}

\item{begin_state}{A \code{character} string for an additional begin state.
This state is added as the first observation for every sequence to
signify the beginning of the sequence}

\item{end_state}{A \code{character} string for an additional end state.
This state is added as the last observation for every sequence to
siginify the end of the sequence.}

\item{...}{Ignored. For the \code{build_model} aliases (e.g., \code{tna}), this
argument matches the actual arguments to \code{build_model} beside \code{x}.}
}
\value{
An object of class \code{tna} which is a \code{list} containing the
following elements:
\itemize{
\item \code{weights}: An adjacency \code{matrix} of the model (weight matrix).
\item \code{inits}: A \code{numeric} vector of initial values for each state.
For \code{matrix} type \code{x}, this element will be \code{NULL} if \code{inits} is not
directly provided
\item \code{labels}: A \code{character} vector of the state labels, or \code{NULL} if
there are no labels.
\item \code{data}: The original sequence data that has been converted to an
internal format used by the package when \code{x} is a \code{stslist} or a
\code{data.frame} object. Otherwise \code{NULL}.
}
}
\description{
Construct a transition network analysis (TNA) model from sequence data.
The function takes a data set of sequence of events or states as input and
builds a TNA model. It extracts the edge weights and initial probabilities
from the data along with the state labels. The function also accepts weight
matrices and initial state probabilities directly.
}
\examples{
model <- build_model(group_regulation)
print(model)

model <- tna(group_regulation)

model <- ftna(group_regulation)

model <- ctna(group_regulation)

model <- atna(group_regulation)

}
\seealso{
Basic functions
\code{\link{hist.group_tna}()},
\code{\link{hist.tna}()},
\code{\link{plot.group_tna}()},
\code{\link{plot.tna}()},
\code{\link{plot_frequencies}()},
\code{\link{plot_frequencies.group_tna}()},
\code{\link{plot_mosaic}()},
\code{\link{plot_mosaic.group_tna}()},
\code{\link{plot_mosaic.tna_data}()},
\code{\link{print.group_tna}()},
\code{\link{print.summary.group_tna}()},
\code{\link{print.summary.tna}()},
\code{\link{print.tna}()},
\code{\link{summary.group_tna}()},
\code{\link{summary.tna}()},
\code{\link{tna-package}}
}
\concept{basic}
