% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_analysis_multi.R
\name{param_summary_multi}
\alias{param_summary_multi}
\title{Resumo para varios parametros (filtro por rio/ponto)}
\usage{
param_summary_multi(
  df,
  parametros,
  rios = NULL,
  pontos = NULL,
  period = c("none", "month", "quarter", "year"),
  na_rm = TRUE
)
}
\arguments{
\item{df}{Data frame com colunas necessarias (ver \code{param_summary()}).}

\item{parametros}{Vetor de nomes de parametros (ex.: c("turbidez","od","pH")).}

\item{rios}{Vetor de rios para filtrar (opcional; usa coluna \code{rio} se existir).}

\item{pontos}{Vetor de pontos para filtrar (opcional; usa coluna \code{ponto} se existir).}

\item{period}{"none","month","quarter","year" (igual a \code{param_summary()}).}

\item{na_rm}{Logical; repassado para \code{param_summary()}.}
}
\value{
Tibble combinando os resumos de todos os parametros,
com coluna \code{parametro} indicando a origem.
}
\description{
Itera sobre um vetor de \code{parametros}, chamando \code{param_summary()} para cada um,
e combina as saidas em uma unica tabela, acrescentando a coluna \code{parametro}.
}
\examples{
\dontrun{
data("wq_demo", package = "tikatuwq")
param_summary_multi(wq_demo, c("turbidez","od"), pontos = c("P1","P2"))
}
}
\seealso{
Other parameter-tools: 
\code{\link{param_plot}()},
\code{\link{param_plot_multi}()},
\code{\link{param_summary}()},
\code{\link{param_trend}()},
\code{\link{param_trend_multi}()}
}
\concept{parameter-tools}
