% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R
\name{slice}
\alias{slice}
\title{slice ee$ImageCollections or tidyee objects that contain imageCollections}
\arguments{
\item{.data}{ImageCollection or tidyee class object}

\item{...}{other arguments}
}
\value{
sliced/filtered image or imageCollection form filtered imageCollection
}
\description{
slice ee$ImageCollections or tidyee objects that contain imageCollections
}
\examples{
\dontrun{

library(rgee)
library(tidyrgee)
ee_Initialize()
l8 = ee$ImageCollection('LANDSAT/LC08/C01/T1_SR')
l8 |>
    filter(date>"2016-01-01",date<"2016-03-04")


 # example with tidyee ckass
modis_ic <- ee$ImageCollection("MODIS/006/MOD13Q1")
modis_ic_tidy <- as_tidyee(modis_ic)

# filter by month
modis_march_april <- modis_ic_tidy |>
filter(month \%in\% c(3,4))
}
}
\seealso{
\code{\link[dplyr]{slice}} for information about slice on normal data tables.
}
