% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spread_values.R
\name{spread_values}
\alias{spread_values}
\title{Spreads specific scalar values of a JSON object into new columns}
\usage{
spread_values(.x, ...)
}
\arguments{
\item{.x}{a json string or \code{\link{tbl_json}} object}

\item{...}{\code{column = value} pairs where \code{column} will be the
column name created and \code{value} must be a call to
\code{\link{jstring}}, \code{\link{jnumber}} or
\code{\link{jlogical}} specifying the path to get the value (and
the type implicit in the function name)}
}
\value{
a \code{\link{tbl_json}} object
}
\description{
The \code{spread_values} function lets you extract extract specific values
from (potentiall nested) JSON objects. \code{spread_values} takes
\code{\link{jstring}}, \code{\link{jnumber}} or \code{\link{jlogical}} named
function calls as arguments in order to specify the type of the data that
should be captured at each desired name-value pair location. These values can
be of varying types at varying depths.
}
\details{
Note that \code{\link{jstring}}, \code{\link{jnumber}} and
\code{\link{jlogical}} will fail if they encounter the incorrect type in any
document.

The advantage of \code{spread_values} over \code{\link{spread_all}} is that
you are guaranteed to get a consistent data frame structure (columns and
types) out of any \code{spread_values} call. \code{\link{spread_all}}
requires less typing, but because it infers the columns and their types from
the JSON, it is less suitable when programming.
}
\examples{

# A simple example
json <- '{"name": {"first": "Bob", "last": "Jones"}, "age": 32}'

# Using spread_values
json \%>\%
  spread_values(
    first.name = jstring(name, first),
    last.name  = jstring(name, last),
    age        = jnumber(age)
  )

# Another document, this time with a middle name (and no age)
json2 <- '{"name": {"first": "Ann", "middle": "A", "last": "Smith"}}'

# spread_values still gives the same column structure
c(json, json2) \%>\%
  spread_values(
    first.name = jstring(name, first),
    last.name  = jstring(name, last),
    age        = jnumber(age)
  )

# whereas spread_all adds a new column
json \%>\% spread_all
c(json, json2) \%>\% spread_all
}
\seealso{
\code{\link{spread_all}} for spreading all values,
         \code{\link[tidyr]{spread}} for spreading data frames,
         \code{\link{jstring}}, \code{\link{jnumber}},
         \code{\link{jlogical}} for accessing specific names
}
