% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smith_waterman.R
\name{smith_waterman_pairwise}
\alias{smith_waterman_pairwise}
\title{Perform multiple alignments using Smith-Waterman}
\usage{
smith_waterman_pairwise(a, b, FUN = identity, ...)
}
\arguments{
\item{a}{a data.frame with columns doc_id and text. Or a character vector where the names of the character vector respresent a doc_id and the character vector corresponds to the text.}

\item{b}{a data.frame with columns doc_id and text. Or a character vector where the names of the character vector respresent a doc_id and the character vector corresponds to the text.}

\item{FUN}{a function to apply on an object of class \code{smith_waterman} which has done the pairwise alignment. 
Defaults to \code{identity}. Other options are as.data.frame or your own function. See the examples.}

\item{...}{other arguments passed on to \code{\link{smith_waterman}}}
}
\value{
a list of pairwise Smith-Waterman comparisons after which the FUN argument is applied on all of these pairwise alignments.
The output of the result of FUN is enriched by adding a list element 
a_doc_id and b_doc_id which correspond to the doc_id's provided in \code{a} and \code{b} and which can be used
in order to identify the match.
}
\description{
Utility function to perform all pairwise combinations of alignments between text.
}
\examples{
x <- data.frame(doc_id = c(1, 2),
                text = c("This is some text", "Another set of texts."),
                stringsAsFactors = FALSE)
y <- data.frame(doc_id = c(1, 2, 3),
                text = c("were as some thing", "else, another set", NA_character_),
                stringsAsFactors = FALSE)
alignments <- smith_waterman_pairwise(x, y)
alignments
alignments <- smith_waterman_pairwise(x, y, FUN = as.data.frame)
do.call(rbind, alignments)
alignments <- smith_waterman_pairwise(x, y, 
                                      FUN = function(x) list(sim = x$similarity))
do.call(rbind, alignments)

x <- c("1" = "This is some text", "2" = "Another set of texts.")
y <- c("1" = "were as some thing", "2" = "else, another set", "3" = NA_character_)
alignments <- smith_waterman_pairwise(x, y)
}
\seealso{
\code{\link{smith_waterman}}
}
