% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delayed_choices.R
\name{delayed_choices}
\alias{delayed_choices}
\alias{all_choices}
\alias{first_choice}
\alias{last_choice}
\alias{first_choices}
\alias{last_choices}
\title{Bare constructor for \code{delayed_choices} object}
\usage{
all_choices()

first_choice()

last_choice()

first_choices(n)

last_choices(n)
}
\arguments{
\item{n}{positive (\code{integer}-like) number of first/last items to subset to}
}
\value{
Object of class \verb{delayed_data, delayed_choices}, which is a function
that returns the appropriate subset of its argument.
\code{all_choices}, \code{first_choices}, and \code{last_choices} structures
also have an additional class for internal use.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Special S3 structures that delay selection of possible choices in a
\code{filter_spec}, \code{select_spec} or \code{choices_selected} object.
}
\examples{
# These pairs of structures represent semantically identical specifications:
choices_selected(choices = letters, selected = letters)
choices_selected(choices = letters, selected = all_choices())

choices_selected(choices = letters, selected = letters[1])
choices_selected(choices = letters, selected = first_choice())

choices_selected(choices = letters, selected = letters[length(letters)])
choices_selected(choices = letters, selected = last_choice())

choices_selected(choices = letters, selected = head(letters, 4))
choices_selected(choices = letters, selected = first_choices(4))

choices_selected(choices = letters, selected = tail(letters, 4))
choices_selected(choices = letters, selected = last_choices(4))

filter_spec(
  vars = c("selected_variable"),
  choices = c("value1", "value2", "value3"),
  selected = "value3"
)
filter_spec(
  vars = c("selected_variable"),
  choices = c("value1", "value2", "value3"),
  selected = last_choice()
)

}
