% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TableBlock.R
\docType{class}
\name{TableBlock}
\alias{TableBlock}
\title{\code{TableBlock}}
\description{
Specialized \code{FileBlock} for managing table content in reports.
It's designed to handle various table formats, converting them into a consistent,
document-ready format (e.g., \code{flextable}) for inclusion in reports.
}
\examples{

## ------------------------------------------------
## Method `TableBlock$set_content`
## ------------------------------------------------

TableBlock <- getFromNamespace("TableBlock", "teal.reporter")
block <- TableBlock$new()
block$set_content(iris)

}
\keyword{internal}
\section{Super classes}{
\code{\link[teal.reporter:ContentBlock]{teal.reporter::ContentBlock}} -> \code{\link[teal.reporter:FileBlock]{teal.reporter::FileBlock}} -> \code{TableBlock}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TableBlock-new}{\code{TableBlock$new()}}
\item \href{#method-TableBlock-set_content}{\code{TableBlock$set_content()}}
\item \href{#method-TableBlock-clone}{\code{TableBlock$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="teal.reporter" data-topic="ContentBlock" data-id="get_content"><a href='../../teal.reporter/html/ContentBlock.html#method-ContentBlock-get_content'><code>teal.reporter::ContentBlock$get_content()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.reporter" data-topic="FileBlock" data-id="from_list"><a href='../../teal.reporter/html/FileBlock.html#method-FileBlock-from_list'><code>teal.reporter::FileBlock$from_list()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.reporter" data-topic="FileBlock" data-id="to_list"><a href='../../teal.reporter/html/FileBlock.html#method-FileBlock-to_list'><code>teal.reporter::FileBlock$to_list()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableBlock-new"></a>}}
\if{latex}{\out{\hypertarget{method-TableBlock-new}{}}}
\subsection{Method \code{new()}}{
Initialize a \code{TableBlock} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableBlock$new(table)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{table}}{(\code{data.frame} or \code{rtables} or \code{TableTree} or \code{ElementaryTable} or \code{listing_df}) a table assigned to
this \code{TableBlock}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Object of class \code{TableBlock}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableBlock-set_content"></a>}}
\if{latex}{\out{\hypertarget{method-TableBlock-set_content}{}}}
\subsection{Method \code{set_content()}}{
Sets content of this \code{TableBlock}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableBlock$set_content(content)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{content}}{(\code{data.frame} or \code{rtables} or \code{TableTree} or \code{ElementaryTable} or \code{listing_df})
a table assigned to this \code{TableBlock}}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Raises error if argument is not a table-like object.
}

\subsection{Returns}{
\code{self}, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{TableBlock <- getFromNamespace("TableBlock", "teal.reporter")
block <- TableBlock$new()
block$set_content(iris)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableBlock-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TableBlock-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableBlock$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
