% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plantminer.R
\name{plantminer}
\alias{plantminer}
\title{Search for taxonomy data from Plantminer.com}
\usage{
plantminer(plants, from = "tpl", messages = TRUE, ...)
}
\arguments{
\item{plants}{(character) Vector of plant species names. Required.}

\item{from}{(character) One of tpl (for theplantlist.com data), or
flora (for Brazilian Flora Checklist). Required. Default: \code{tpl}}

\item{messages}{(logical) informative messages or not. 
Default: \code{TRUE}}

\item{...}{curl options passed on to \code{\link[crul]{HttpClient}}}
}
\value{
data.frame of results.
}
\description{
Search for taxonomy data from Plantminer.com
}
\note{
you used to need an API key for Plantminer; it's no longer needed
}
\examples{
\dontrun{
# A single taxon
plantminer("Ocotea pulchella")

# Many taxa
plants <- c("Myrcia lingua", "Myrcia bella", "Ocotea pulchella",
		"Miconia", "Coffea arabica var. amarella", "Bleh")
plantminer(plants)

# By deafult, tpl is used, for Theplantlist data,
# toggle the from parameter here
plantminer("Ocotea pulchella", from = "flora")
}
}
