% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_wiki.R
\name{get_wiki}
\alias{get_wiki}
\alias{as.wiki}
\alias{as.wiki.wiki}
\alias{as.wiki.character}
\alias{as.wiki.list}
\alias{as.wiki.numeric}
\alias{as.wiki.data.frame}
\alias{as.data.frame.wiki}
\alias{get_wiki_}
\title{Get the page name for a Wiki taxon}
\usage{
get_wiki(x, wiki_site = "species", wiki = "en", ask = TRUE,
  verbose = TRUE, limit = 100, rows = NA, ...)

as.wiki(x, check = TRUE, wiki_site = "species", wiki = "en")

\method{as.wiki}{wiki}(x, check = TRUE, wiki_site = "species",
  wiki = "en")

\method{as.wiki}{character}(x, check = TRUE, wiki_site = "species",
  wiki = "en")

\method{as.wiki}{list}(x, check = TRUE, wiki_site = "species",
  wiki = "en")

\method{as.wiki}{numeric}(x, check = TRUE, wiki_site = "species",
  wiki = "en")

\method{as.wiki}{data.frame}(x, check = TRUE, wiki_site = "species",
  wiki = "en")

\method{as.data.frame}{wiki}(x, ...)

get_wiki_(x, verbose = TRUE, wiki_site = "species", wiki = "en",
  limit = 100, rows = NA, ...)
}
\arguments{
\item{x}{(character) A vector of common or scientific names.}

\item{wiki_site}{(character) Wiki site. One of species (default), pedia,
commons}

\item{wiki}{(character) language. Default: en}

\item{ask}{logical; should get_wiki be run in interactive mode?
If \code{TRUE} and more than one wiki is found for the species, the user is
asked for input. If \code{FALSE} NA is returned for multiple matches.}

\item{verbose}{logical; should progress be printed?}

\item{limit}{(integer) number of records to return}

\item{rows}{numeric; Any number from 1 to infinity. If the default NA, all
rows are considered. Note that this function still only gives back a wiki
class object with one to many identifiers. See
\code{\link[taxize]{get_wiki_}} to get back all, or a subset, of the
raw data that you are presented during the ask process.}

\item{...}{Ignored}

\item{check}{logical; Check if ID matches any existing on the DB, only
used in \code{\link{as.wiki}}}
}
\value{
A vector of taxonomic identifiers as an S3 class.
If a taxon is not found an \code{NA} is given. If more than one identifier
is found the function asks for user input if \code{ask = TRUE}, otherwise
returns \code{NA}. If \code{ask=FALSE} and \code{rows} does not equal
\code{NA}, then a data.frame is given back, but not of the uid class, which
you can't pass on to other functions as you normally can.

See \code{\link{get_id_details}} for further details including
attributes and exceptions
}
\description{
Get the page name for a Wiki taxon
}
\details{
For \code{type = pedia}, we use the english language site by
default. Set the \code{language} parameter for a different language site.
}
\examples{
\dontrun{
get_wiki(x = "Quercus douglasii")
get_wiki(x = "Quercu")
get_wiki(x = "Quercu", "pedia")
get_wiki(x = "Quercu", "commons")

# diff. wikis with wikipedia
get_wiki("Malus domestica", "pedia")
get_wiki("Malus domestica", "pedia", "fr")

# as coercion
as.wiki("Malus_domestica")
as.wiki("Malus_domestica", wiki_site = "commons")
as.wiki("Malus_domestica", wiki_site = "pedia")
as.wiki("Malus_domestica", wiki_site = "pedia", wiki = "fr")
as.wiki("Malus_domestica", wiki_site = "pedia", wiki = "da")
}
}
\seealso{
\code{\link[taxize]{classification}}

Other taxonomic-ids: \code{\link{get_boldid}},
  \code{\link{get_colid}}, \code{\link{get_eolid}},
  \code{\link{get_gbifid}}, \code{\link{get_ids}},
  \code{\link{get_iucn}}, \code{\link{get_natservid}},
  \code{\link{get_nbnid}}, \code{\link{get_tolid}},
  \code{\link{get_tpsid}}, \code{\link{get_tsn}},
  \code{\link{get_uid}}, \code{\link{get_wormsid}}
}
\concept{taxonomic-ids}
