% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iucn_getname.R
\name{iucn_getname}
\alias{iucn_getname}
\title{Get any matching IUCN species names}
\usage{
iucn_getname(name, verbose = TRUE, ...)
}
\arguments{
\item{name}{character; taxon name}

\item{verbose}{logical; should messages be printed?}

\item{...}{Further arguments passed on to \code{\link{iucn_summary}}}
}
\value{
Character vector of names that matched in IUCN
}
\description{
Get any matching IUCN species names
}
\details{
Beware: IUCN functions can give back incorrect data. This isn't
our fault. We do our best to get you the correct data quickly, but sometimes
IUCN gives back the wrong data, and sometimes Global Names gives back the
wrong data. We will fix these as soon as possible. In the meantime, just
make sure that the data you get back is correct.
}
\examples{
\dontrun{
iucn_getname(name = "Cyanistes caeruleus")
iucn_getname(name = "Panthera uncia")
iucn_getname(name = "Abies")

# not found in global names
# iucn_getname(name = "Abronia pinsapo")

# not found in IUCN search
# iucn_getname(name = "Acacia allenii")
}
}
\seealso{
\code{\link{iucn_summary}} \code{\link{iucn_status}}
}
