\name{gisd_isinvasive}
\alias{gisd_isinvasive}
\title{Check invasive species status for a set of species from GISD database}
\usage{
  gisd_isinvasive(x, simplify = FALSE, verbose = TRUE)
}
\arguments{
  \item{x}{character; a vector of scientific species names
  in the form of c("Genus species").}

  \item{simplify}{logical; returns a data.frame with the
  species name and the values "Invasive", "Not in GISD". I
  recomend to check first the not simplified version
  (default), which contains raw information about the level
  of invasiveness.}

  \item{verbose}{logical; If TRUE (default), informative
  messages printed.}
}
\value{
  A data.frame with species names and invasiveness.
}
\description{
  This function check which species (both plants and
  animals) are considered "invaders" somewhere in the
  world.

  For that end, it checks GISD
  (http://www.issg.org/database/welcome/) and returns a
  value, either "Not in GISD" or the brief description
  presented in GISD.

  Note that the webpage contains more information. Also
  note that the function won't tell you if it's exotic in
  your area, a lot of exotic species are not considered
  invaders (yet).

  As expected, the function is as good as the database is,
  which I find quite reliable and well maintained. The
  database is also able to recognize a lot (but not all) of
  the species synonyms.
}
\examples{
\dontrun{
sp <- c("Carpobrotus edulis", "Rosmarinus officinalis")
## first species is invasive, second one is not.
gisd_isinvasive(sp)
gisd_isinvasive(sp, simplify = TRUE)
}
}
\author{
  Ignasi Bartomeus \email{nacho.bartomeus@gmail.com}
}

