% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R, R/tanaka.R
\docType{package}
\name{tanaka}
\alias{tanaka}
\alias{tanaka-package}
\title{tanaka}
\usage{
tanaka(x, nclass = 8, breaks, col, mask, light = "#ffffff70",
  dark = "#00000090", shift, legend.pos = "left",
  legend.title = "Elevation")
}
\arguments{
\item{x}{a raster or an sf contour layer (e.g. the result of \code{tanaka_contour()}).}

\item{nclass}{a number of class.}

\item{breaks}{a list of breaks.}

\item{col}{a color palette (a vector of colors).}

\item{mask}{a mask layer, a POLYGON or MULTIPOLYGON sf object.}

\item{light}{light shadow (NW color).}

\item{dark}{dark shadow (SE color).}

\item{shift}{size of the shadow (in map units).}

\item{legend.pos}{position of the legend, one of "topleft", "top",
"topright", "right", "bottomright", "bottom", "bottomleft", "left" or a
vector of two coordinates in map units (c(x, y)). If
legend.pos="n" then the legend is not plotted.}

\item{legend.title}{title of the legend.}
}
\value{
A Tanaka contour map is plotted.
}
\description{
Tanaka pkg

This function plots a tanaka map.
}
\examples{
library(tanaka)
library(raster)
library(sf)
com <- st_read(system.file("gpkg/com.gpkg", package = "tanaka"), quiet = TRUE)
ras <- raster(system.file("grd/elev.grd", package = "tanaka"))
tanaka(ras)
tanaka(ras, mask = com)
tanaka(ras, breaks = seq(80,400,20),
       legend.pos = "topright",
       legend.title = "Elevation\\n(meters)")
}
\references{
Tanaka, K. (1950). The relief contour method of representing
topography on maps. \emph{Geographical Review, 40}(3), 444-456.
}
